import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import tailwindcss from '@tailwindcss/vite'
import { fileURLToPath } from 'url'
import { dirname, resolve } from 'path'

const __filename = fileURLToPath(import.meta.url)
const __dirname = dirname(__filename)

// https://vite.dev/config/
export default defineConfig({
  appType: 'spa',
  plugins: [react(), tailwindcss()],
   base: '/frontend/dist/',
  define: {
    global: 'window',
  },
  resolve: {
    alias: {
      '@edtr-io/mathquill': resolve(__dirname, 'node_modules/@edtr-io/mathquill')
    }
  },
  // Pastikan asset path relatif agar cocok saat deploy di subfolder
  base: '/',
  server: {
    port: 5173,
    strictPort: true,
    host: true,
    // Gunakan environment VITE_BACKEND_URL (default ke localhost:8000)
    // agar proxy bekerja baik di Docker maupun lokal.
    proxyTarget: process.env.VITE_BACKEND_URL || 'http://127.0.0.1:8000',
    proxy: {
      // Proxy semua request API ke server Laravel
      '/api': {
        target: process.env.VITE_BACKEND_URL || 'http://127.0.0.1:8000',
        changeOrigin: true,
        // Jika backend berada di akar /api, tidak perlu rewrite
        // rewrite: (path) => path.replace(/^\/api/, ''),
      },
      // Endpoint CSRF Sanctum
      '/sanctum': {
        target: process.env.VITE_BACKEND_URL || 'http://127.0.0.1:8000',
        changeOrigin: true,
      },
    },
  },
})
