export function sanitizeLatex(input) {
  const s = String(input || '');
  let out = s.normalize('NFKC')
    // Remove invisible / zero-width characters
    .replace(/[\u200B-\u200D\uFEFF]/g, '')
    .replace(/\u0332/g, '')
    // Replace non-breaking spaces and smart quotes
    .replace(/\u00A0/g, ' ')
    .replace(/[“”]/g, '"')
    .replace(/[‘’]/g, "'")
    .replace(/∣/g, '|')
    .replace(/−/g, '-')
    .replace(/∕/g, '/')
    // Normalize fullwidth or Unicode variants of core math delimiters
    .replace(/＆/g, '&')
    .replace(/＼/g, '\\');

  // Wrap \v{...} and \r{...} in \text{...} to avoid accent macro parse issues
  out = out
    .replace(/\\v\s*\{([^}]*)\}/g, "\\text{\\v{$1}}")
    .replace(/\\r\s*\{([^}]*)\}/g, "\\text{\\r{$1}}");

  // Fix malformed sizing delimiters (\bigm{|} → \bigm|)
  out = out
    .replace(/\\(bigm|Bigm|biggm|Biggm)\s*\{\s*\|\s*\}/g, "\\$1|")
    .replace(/\\(bigm|Bigm|biggm|Biggm)\s*\{\s*\\mid\s*\}/g, "\\$1|")
    .replace(/\\(bigm|Bigm|biggm|Biggm)\s*\{\s*\(\s*\}/g, "\\$1(")
    .replace(/\\(bigm|Bigm|biggm|Biggm)\s*\{\s*\)\s*\}/g, "\\$1)")
    .replace(/\\(bigm|Bigm|biggm|Biggm)\s*\{\s*\[\s*\}/g, "\\$1[")
    .replace(/\\(bigm|Bigm|biggm|Biggm)\s*\{\s*\]\s*\}/g, "\\$1]");

  // Fallback for weird \bigm\| usage
  out = out.replace(/\\bigm\\\|/g, "\\Big|");

  // Final fallback: remove any remaining non-ASCII characters
  out = out.replace(/[^\x00-\x7F]/g, '');

  return out;
}