import React, { useEffect, useState } from 'react';
import { Link } from 'react-router-dom';
import api from '../utils/axios';

export default function TodayPublic() {
  const [loading, setLoading] = useState(true);
  const [exams, setExams] = useState([]);
  const [error, setError] = useState('');

  useEffect(() => {
    const load = async () => {
      setLoading(true); setError('');
      try {
        const res = await api.get('/exams/today');
        setExams(Array.isArray(res.data) ? res.data : []);
      } catch (e) {
        console.error('Gagal memuat ujian hari ini (publik)', e);
        setError('Gagal memuat data ujian hari ini.');
      } finally {
        setLoading(false);
      }
    };
    load();
  }, []);

  const fmt = (iso) => {
    if (!iso) return '-';
    const d = new Date(iso);
    return d.toLocaleString();
  };

  return (
    <div className="container mt-4">
      <h3>Mata Pelajaran Hari Ini (Publik)</h3>
      <p className="text-muted">Halaman ini menggunakan endpoint publik dan dapat diakses tanpa login.</p>

      {loading ? (
        <div className="text-muted">Memuat data...</div>
      ) : error ? (
        <div className="alert alert-danger">{error}</div>
      ) : exams.length === 0 ? (
        <div className="text-muted">Tidak ada ujian yang dijadwalkan hari ini.</div>
      ) : (
        <div className="card">
          <div className="card-body">
            <div className="table-responsive">
              <table className="table table-sm">
                <thead>
                  <tr>
                    <th>Mata Pelajaran</th>
                    <th>Kode Mapel</th>
                    <th>Nama Ujian</th>
                    <th>Kode Ujian</th>
                   <th>Jadwal</th>
                   <th>Sedang</th>
                   <th>Selesai</th>
                    <th>Aksi</th>
                  </tr>
                </thead>
                <tbody>
                  {exams.map(ex => (
                    <tr key={ex.id}>
                      <td>{ex.subject_name || '-'}</td>
                      <td>{ex.subject_code || '-'}</td>
                      <td>{ex.name}</td>
                      <td>{ex.code || '-'}</td>
                      <td>{fmt(ex.start_at_iso)} - {fmt(ex.end_at_iso)}</td>
                      <td>{ex.in_progress_count ?? 0}</td>
                      <td>{ex.finished_count ?? 0}</td>
                      <td>
                        <Link to={`/today-public/${ex.id}`} className="btn btn-sm btn-outline-primary">Detail</Link>
                      </td>
                    </tr>
                  ))}
                </tbody>
              </table>
            </div>
            <small className="text-muted">Data diambil dari /exams/today.</small>
          </div>
        </div>
      )}
    </div>
  );
}