import React, { useState } from "react";
import { FaEye, FaEyeSlash, FaUserPlus, FaSignInAlt } from "react-icons/fa";
import api from "../utils/axios";
import Swal from "sweetalert2";

export default function Login() {
  // Login states
  const [email, setEmail] = useState("");
  const [password, setPassword] = useState("");
  const [loading, setLoading] = useState(false);
  const [showPasswordLogin, setShowPasswordLogin] = useState(false);

  // Registrasi states
  const [showRegister, setShowRegister] = useState(false);
  const [name, setName] = useState("");
  const [regEmail, setRegEmail] = useState("");
  const [regPassword, setRegPassword] = useState("");
  const [regPasswordConfirm, setRegPasswordConfirm] = useState("");
  const [role, setRole] = useState("murid");
  const [regLoading, setRegLoading] = useState(false);
  const [showPasswordReg, setShowPasswordReg] = useState(false);
  const [showPasswordReg2, setShowPasswordReg2] = useState(false);

  const handleLoginSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);
    try {
      const res = await api.post("/login", { email, password }, { headers: { 'Cache-Control': 'no-store', 'Pragma': 'no-cache' } });
      const { token, user: rawUser, permissions, expires_in } = res.data || {};
      const user = rawUser ? { ...rawUser, permissions: permissions || [] } : null;
      if (!token || !user) throw new Error('Login response tidak valid');
      localStorage.setItem("token", token);
      localStorage.setItem("user", JSON.stringify(user));
      if (expires_in) {
        localStorage.setItem("token_expires", String(Date.now() + Number(expires_in) * 1000));
      }
      // Redirect admin to dashboard to avoid host root redirect to /exam/login
      window.location.replace("/dashboard");
    } catch (err) {
      console.error(err);
      Swal.fire("Login Gagal", err?.response?.data?.message || "Periksa email dan password Anda", "error");
    } finally {
      setLoading(false);
    }
  };

  const handleRegisterSubmit = async (e) => {
    e.preventDefault();
    if (regPassword !== regPasswordConfirm) {
      Swal.fire("Validasi Gagal", "Konfirmasi password tidak cocok", "warning");
      return;
    }
    setRegLoading(true);
    try {
      await api.post("/register", {
        name: name.trim(),
        email: regEmail.trim(),
        password: regPassword,
        password_confirmation: regPasswordConfirm,
        role,
        status: "Tidak Aktif",
      });
      await Swal.fire({
        icon: "success",
        title: "Berhasil",
        text: "Selamat Registrasi Berhasil. Akun belum aktif, silangkan menunggu persetujuan admin.",
        confirmButtonText: "OK",
      });
      setShowRegister(false);
      setName("");
      setRegEmail("");
      setRegPassword("");
      setRegPasswordConfirm("");
      setRole("murid");
    } catch (err) {
      console.error(err);
      Swal.fire("Registrasi Gagal", err?.response?.data?.message || "Terjadi kesalahan. Coba lagi.", "error");
    } finally {
      setRegLoading(false);
    }
  };

  return (
    <div
      className="min-vh-100 d-flex align-items-center justify-content-center"
      style={{ background: "linear-gradient(90deg, #212529 0%, #0d6efd 100%)" }}
    >
      <div className="card shadow-lg border-0 rounded-4" style={{ width: "100%", maxWidth: 460 }}>
        <div className="card-body p-4 p-md-5">
          <div className="d-flex justify-content-center align-items-center gap-3 mb-3">
            <img src={`${import.meta.env.BASE_URL}reacti.svg`} alt="React logo" height="42" />
            <img src={`${import.meta.env.BASE_URL}vite.svg`} alt="Vite logo" height="42" />
          </div>
          <h3 className="text-center fw-bold mb-2">Selamat Datang</h3>
          <p className="text-center text-muted mb-4">Masuk ke Admin Panel</p>

          <form onSubmit={handleLoginSubmit} autoComplete="off">
            <div className="form-floating mb-3">
              <input
                type="email"
                className="form-control"
                id="email"
                placeholder="name@example.com"
                value={email}
                onChange={(e) => setEmail(e.target.value)}
                required
                autoFocus
                autoComplete="off"
                autoCapitalize="off"
                spellCheck={false}
              />
              <label htmlFor="email">Email</label>
            </div>

            <div className="form-floating mb-3 position-relative">
              <input
                type={showPasswordLogin ? "text" : "password"}
                className="form-control"
                id="password"
                placeholder="Password"
                value={password}
                onChange={(e) => setPassword(e.target.value)}
                required
                autoComplete="off"
                autoCapitalize="off"
                spellCheck={false}
              />
              <label htmlFor="password">Password</label>
              <button
                type="button"
                className="btn btn-link position-absolute top-50 end-0 translate-middle-y px-2"
                style={{ zIndex: 3 }}
                aria-label={showPasswordLogin ? "Sembunyikan password" : "Tampilkan password"}
                onClick={() => setShowPasswordLogin((v) => !v)}
              >
                {showPasswordLogin ? <FaEyeSlash /> : <FaEye />}
              </button>
            </div>

            <button className="btn btn-primary w-100 d-inline-flex align-items-center justify-content-center" type="submit" disabled={loading} >
              {loading ? (
                <>
                  <span className="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                  Memproses...
                </>
              ) : (
                <>
                  <FaSignInAlt className="me-2" /> Masuk
                </>
              )}
            </button>
          </form>

          {/* Toggle Form Registrasi */}
          <div className="mt-3">
            <button
              type="button"
              className="btn w-100 d-inline-flex align-items-center justify-content-center"
              style={{ backgroundColor: "#2ecc71", borderColor: "#2ecc71", color: "#fff" }}
              onClick={() => {
                setShowRegister((v) => !v);
                if (!showRegister) setRegEmail(email);
              }}
            >
              <FaUserPlus className="me-2" /> {showRegister ? "Tutup Form Pendaftaran" : "Daftarkan Akun Baru"}
            </button>
          </div>

          {showRegister && (
            <div className="mt-3">
              {/* Status tidak ditampilkan */}
              <form onSubmit={handleRegisterSubmit} autoComplete="off">
                <div className="form-floating mb-2">
                  <input
                    type="text"
                    className="form-control form-control-sm"
                    id="reg-name"
                    placeholder="Nama lengkap"
                    value={name}
                    onChange={(e) => setName(e.target.value)}
                    required
                  />
                  <label htmlFor="reg-name">Nama lengkap</label>
                </div>

                <div className="form-floating mb-2">
                  <input
                    type="email"
                    className="form-control form-control-sm"
                    id="reg-email"
                    placeholder="Email"
                    value={regEmail}
                    onChange={(e) => setRegEmail(e.target.value)}
                    required
                  />
                  <label htmlFor="reg-email">Email</label>
                </div>

                <div className="row g-2">
                  <div className="col-6">
                    <div className="form-floating mb-2 position-relative">
                      <input
                        type={showPasswordReg ? "text" : "password"}
                        className="form-control form-control-sm"
                        id="reg-pass"
                        placeholder="Password"
                        value={regPassword}
                        onChange={(e) => setRegPassword(e.target.value)}
                        required
                        autoComplete="off"
                      />
                      <label htmlFor="reg-pass">Password</label>
                      <button
                        type="button"
                        className="btn btn-link position-absolute top-50 end-0 translate-middle-y px-2"
                        style={{ zIndex: 3 }}
                        aria-label={showPasswordReg ? "Sembunyikan password" : "Tampilkan password"}
                        onClick={() => setShowPasswordReg((v) => !v)}
                      >
                        {showPasswordReg ? <FaEyeSlash /> : <FaEye />}
                      </button>
                    </div>
                  </div>
                  <div className="col-6">
                    <div className="form-floating mb-2 position-relative">
                      <input
                        type={showPasswordReg2 ? "text" : "password"}
                        className="form-control form-control-sm"
                        id="reg-pass2"
                        placeholder="Konfirmasi Password"
                        value={regPasswordConfirm}
                        onChange={(e) => setRegPasswordConfirm(e.target.value)}
                        required
                        autoComplete="off"
                      />
                      <label htmlFor="reg-pass2">Konfirmasi Password</label>
                      <button
                        type="button"
                        className="btn btn-link position-absolute top-50 end-0 translate-middle-y px-2"
                        style={{ zIndex: 3 }}
                        aria-label={showPasswordReg2 ? "Sembunyikan password" : "Tampilkan password"}
                        onClick={() => setShowPasswordReg2((v) => !v)}
                      >
                        {showPasswordReg2 ? <FaEyeSlash /> : <FaEye />}
                      </button>
                    </div>
                  </div>
                </div>

                <div className="form-floating mb-2">
                  <select
                    className="form-select form-select-sm"
                    id="reg-role"
                    value={role}
                    onChange={(e) => setRole(e.target.value)}
                    required
                  >
                    <option value="guru">Guru</option>
                    <option value="murid">Murid</option>
                  </select>
                  <label htmlFor="reg-role">Peran</label>
                </div>

                {/* Status field disembunyikan, tidak ditampilkan */}

                <button
                  className="btn w-100 d-inline-flex align-items-center justify-content-center"
                  type="submit"
                  disabled={regLoading}
                  style={{ backgroundColor: "#14532d", borderColor: "#14532d", color: "#fff" }}
                >
                  {regLoading ? (
                    <>
                      <span className="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                      Memproses...
                    </>
                  ) : (
                    <>
                      <FaUserPlus className="me-2" /> Daftar
                    </>
                  )}
                </button>
              </form>
            </div>
          )}

          <div className="mt-3 text-center">
            <small className="text-muted">Lupa password? Hubungi admin sistem.</small>
          </div>
        </div>
      </div>
    </div>
  );
}
