import React from 'react';
import { Navigate } from 'react-router-dom';
import { useAuth } from "../context/AuthContext.jsx";

const ProtectedRoute = ({ children, requiredRole }) => {
  const { user, loading, hasRole } = useAuth();

  if (loading) return <div className="text-center mt-5">Loading...</div>;
  // Ubah: jika belum login, arahkan ke /exam/login
  if (!user) return <Navigate to="/exam/login" />;

  if (requiredRole && !hasRole(requiredRole)) return <h3>Akses Ditolak</h3>;

  return children;
};

export default ProtectedRoute;
