import React, { useEffect } from 'react';

export default function Notification({
  type = 'info',
  title,
  message,
  onClose,
  duration = 5000,
}) {
  useEffect(() => {
    const t = setTimeout(() => onClose && onClose(), duration);
    return () => clearTimeout(t);
  }, [duration, onClose]);

  return (
    <div className={`notif notif--${type}`} role="alert">
      <div className="notif__content">
        <div className="notif__icon" aria-hidden="true" />
        <div className="notif__text">
          {title && <div className="notif__title">{title}</div>}
          {message && <div className="notif__message">{message}</div>}
        </div>
        <button className="notif__close" onClick={onClose} aria-label="Tutup">×</button>
      </div>
    </div>
  );
}