import React, { useEffect, useRef } from 'react';
import $ from 'jquery';
import '@edtr-io/mathquill/build/mathquill.css';

export default function MathInput({ value = '', onChange, placeholder }) {
  const spanRef = useRef(null);
  const mqRef = useRef(null);

  useEffect(() => {
    const setup = async () => {
      if (typeof window !== 'undefined') {
        window.jQuery = $;
        window.$ = $;
      }
      await import('@edtr-io/mathquill/build/mathquill.js');
      const MQ = (window.MathQuill || {}).getInterface ? window.MathQuill.getInterface(2) : null;
      if (!MQ) return;
      mqRef.current = MQ.MathField(spanRef.current, {
        handlers: {
          edit: (mf) => {
            const l = mf.latex();
            onChange && onChange(l);
          }
        }
      });
      if (value) mqRef.current.latex(value);
    };
    setup();

    return () => { mqRef.current = null; };
  }, []);

  useEffect(() => {
    if (mqRef.current && typeof value === 'string' && value !== mqRef.current.latex()) {
      mqRef.current.latex(value);
    }
  }, [value]);

  return (
    <div>
      <span
        ref={spanRef}
        style={{ minHeight: 38, border: '1px solid #ddd', borderRadius: 6, padding: '6px', background: '#fff', display: 'inline-block', width: '100%' }}
      />
      {placeholder && (!value || value.length === 0) && (
        <div className="text-muted small mt-1">{placeholder}</div>
      )}
    </div>
  );
}