import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom';
import api from '../utils/axios';

export default function Login({ onLogin }) {
    const [email, setEmail] = useState('');
    const [password, setPassword] = useState('');
    const [error, setError] = useState('');
    const [loading, setLoading] = useState(false);
    const navigate = useNavigate();


    
    const handleSubmit = async (e) => {
      e.preventDefault();
      setError('');
      setLoading(true);
  
      try {
          // Gunakan token bearer dari /api/login, tidak perlu CSRF cookie
          const resLogin = await api.post('/login', { email, password });
          const token = resLogin?.data?.token;
  
          if (!token) throw new Error('Token tidak tersedia dari server');
          localStorage.setItem('token', token);
  
          const user = resLogin?.data?.user;
          const permissions = resLogin?.data?.permissions || [];
  
          if (!user) throw new Error('User tidak ditemukan');
  
          if (onLogin && typeof onLogin === 'function') {
              onLogin({ ...user, permissions });
          } else {
              console.warn('onLogin props tidak tersedia');
          }
  
          navigate('/');
  
      } catch (err) {
          console.error('Login error:', err.response?.data || err.message);
          setError(
              err.response?.data?.message ||
              err.response?.data?.email?.[0] ||
              err.message ||
              'Email atau password salah'
          );
      } finally {
          setLoading(false);
      }
    };
  

    return (
        <div className="container mt-5" style={{ maxWidth: '400px' }}>
            <h2 className="text-center mb-4">Login</h2>

            {error && <div className="alert alert-danger">{error}</div>}

            <form onSubmit={handleSubmit}>
                <input
                    type="email"
                    className="form-control mb-3"
                    placeholder="Email"
                    value={email}
                    onChange={e => setEmail(e.target.value)}
                    required
                />
                <input
                    type="password"
                    className="form-control mb-3"
                    placeholder="Password"
                    value={password}
                    onChange={e => setPassword(e.target.value)}
                    required
                />
                <button type="submit" className="btn btn-primary w-100" disabled={loading}>
                    {loading ? 'Loading...' : 'Login'}
                </button>
            </form>
        </div>
    );
}
