/* 0.29.1 */
import { TensorField } from './tensor-fields';
import type { BoxedExpression, ComputeEngine, DataTypeMap, TensorData, TensorDataType } from '../global-types';
/** @internal */
export type NestedArray<T> = NestedArray_<T>[];
/** @internal */
export type NestedArray_<T> = T | NestedArray_<T>[];
/** @category Tensors */
export declare abstract class AbstractTensor<DT extends keyof DataTypeMap> implements TensorData<DT> {
    private ce;
    /**
     * Return a tuple of tensors that have the same dtype.
     * If necessary, one of the two input tensors is upcast.
     *
     * The shape of the tensors is reshaped to a compatible
     * shape. If the shape is not compatible, `undefined` is returned.
     *
     * @param lhs
     * @param rhs
     */
    static align<T1 extends TensorDataType, T2 extends TensorDataType>(lhs: AbstractTensor<T1>, rhs: AbstractTensor<T2>): [AbstractTensor<T1>, AbstractTensor<T1>];
    static align<T1 extends TensorDataType, T2 extends TensorDataType>(lhs: AbstractTensor<T1>, rhs: AbstractTensor<T2>): [AbstractTensor<T2>, AbstractTensor<T2>];
    /**
     * Apply a function to the elements of two tensors, or to a tensor
     * and a scalar.
     *
     * The tensors are aligned and broadcasted if necessary.
     *
     * @param fn
     * @param lhs
     * @param rhs
     * @returns
     */
    static broadcast<T extends TensorDataType>(fn: (lhs: DataTypeMap[T], rhs: DataTypeMap[T]) => DataTypeMap[T], lhs: AbstractTensor<T>, rhs: AbstractTensor<T> | DataTypeMap[T]): AbstractTensor<T>;
    readonly field: TensorField<DataTypeMap[DT]>;
    readonly shape: number[];
    readonly rank: number;
    private readonly _strides;
    constructor(ce: ComputeEngine, tensorData: TensorData<DT>);
    abstract get dtype(): DT;
    abstract get data(): DataTypeMap[DT][];
    get expression(): BoxedExpression;
    /**
     * Like expression(), but return a nested JS array instead
     * of a BoxedExpression
     */
    get array(): NestedArray<DataTypeMap[DT]>;
    /** Indices are 1-based, return a 0-based index in the data */
    private _index;
    get isSquare(): boolean;
    get isSymmetric(): boolean;
    get isSkewSymmetric(): boolean;
    get isUpperTriangular(): boolean;
    get isLowerTriangular(): boolean;
    get isTriangular(): boolean;
    get isDiagonal(): boolean;
    get isIdentity(): boolean;
    get isZero(): boolean;
    /**
     *  The number of indices should match the rank of the tensor.
     *
     * Note: the indices are 1-based
     * Note: the data is broadcast (wraps around) if the indices are out of bounds
     *
     * LaTeX notation `A\lbracki, j\rbrack` or `A_{i, j}`
     */
    at(...indices: number[]): DataTypeMap[DT];
    diagonal(axis1?: number, axis2?: number): undefined | DataTypeMap[DT][];
    trace(axis1?: number, axis2?: number): undefined | DataTypeMap[DT];
    /**
     * Change the shape of the tensor
     *
     * The data is reused (and shared) between the two tensors.
     */
    reshape(...shape: number[]): AbstractTensor<DT>;
    flatten(): DataTypeMap[DT][];
    upcast<DT extends keyof DataTypeMap>(dtype: DT): AbstractTensor<DT>;
    /** Transpose the first and second axis */
    transpose(): undefined | AbstractTensor<DT>;
    /** Transpose two axes. */
    transpose(axis1: number, axis2: number, fn?: (v: DataTypeMap[DT]) => DataTypeMap[DT]): undefined | AbstractTensor<DT>;
    conjugateTranspose(axis1: number, axis2: number): undefined | AbstractTensor<DT>;
    determinant(): undefined | DataTypeMap[DT];
    inverse(): undefined | AbstractTensor<DT>;
    pseudoInverse(): undefined | AbstractTensor<DT>;
    adjugateMatrix(): undefined | AbstractTensor<DT>;
    minor(i: number, j: number): undefined | DataTypeMap[DT];
    map1(fn: (lhs: DataTypeMap[DT], rhs: DataTypeMap[DT]) => DataTypeMap[DT], scalar: DataTypeMap[DT]): AbstractTensor<DT>;
    map2(fn: (lhs: DataTypeMap[DT], rhs: DataTypeMap[DT]) => DataTypeMap[DT], rhs: AbstractTensor<DT>): AbstractTensor<DT>;
    add(rhs: AbstractTensor<DT> | DataTypeMap[DT]): AbstractTensor<DT>;
    subtract(rhs: AbstractTensor<DT> | DataTypeMap[DT]): AbstractTensor<DT>;
    multiply(rhs: AbstractTensor<DT> | DataTypeMap[DT]): AbstractTensor<DT>;
    divide(rhs: AbstractTensor<DT> | DataTypeMap[DT]): AbstractTensor<DT>;
    power(rhs: AbstractTensor<DT> | DataTypeMap[DT]): AbstractTensor<DT>;
    equals(rhs: AbstractTensor<DT>): boolean;
}
/** @category Tensors */
export declare function makeTensor<T extends TensorDataType>(ce: ComputeEngine, data: TensorData<T> | {
    operator: string;
    ops: BoxedExpression[];
    dtype: T;
    shape: number[];
}): AbstractTensor<T>;
export { TensorData };
