/* 0.29.1 */
import type { ComputeEngine } from '../global-types';
import type { BigNum } from './types';
export declare function gammaln(z: number): number;
export declare function gamma(z: number): number;
/**
 * Inverse Error Function.
 *
 */
export declare function erfInv(x: number): number;
/**
 * Trivial function, used when compiling.
 */
export declare function erfc(x: number): number;
/**
 * An approximation of the gaussian error function, Erf(), using
 * Abramowitz and Stegun approximation.
 *
 * Thoughts for future improvements:
 * - https://math.stackexchange.com/questions/321569/approximating-the-error-function-erf-by-analytical-functions
 * - https://en.wikipedia.org/wiki/Error_function#Approximation_with_elementary_functions

 *
 * References:
 * - NIST: https://dlmf.nist.gov/7.24#i
 */
export declare function erf(x: number): number;
export declare function bigGammaln(ce: ComputeEngine, z: BigNum): BigNum;
export declare function bigGamma(ce: ComputeEngine, z: BigNum): BigNum;
