/* 0.29.1 */
export declare function gcd(a: bigint, b: bigint): bigint;
export declare function lcm(a: bigint, b: bigint): bigint;
/** Return `[factor, root]` such that
 * pow(n, 1/exponent) = factor * pow(root, 1/exponent)
 *
 * canonicalInteger(75, 2) -> [5, 3] = 5^2 * 3
 *
 */
export declare function canonicalInteger(n: bigint, exponent: number): [factor: bigint, root: bigint];
export declare function reducedInteger(n: bigint): bigint | number;
/**
 * Computes the factorial of a number as a generator to allow interruptibility.
 * Yields intermediate values periodically, but these are not intended to be the primary result.
 *
 * @param n - The number to compute the factorial of (as a BigInt).
 * @returns A generator that can be iterated for intermediate values, with the final value returned when the computation completes.
 */
export declare function factorial(n: bigint): Generator<bigint, bigint>;
