/* 0.29.1 */
import { Decimal } from 'decimal.js';
import { BigNumFactory, NumericValue, NumericValueData } from './types';
import type { Expression } from '../../math-json/types';
import type { SmallInteger } from '../numerics/types';
import { NumericType } from '../../common/type/types';
export declare class MachineNumericValue extends NumericValue {
    __brand: 'MachineNumericValue';
    decimal: number;
    im: number;
    bignum: BigNumFactory;
    constructor(value: number | Decimal | NumericValueData, bignum: BigNumFactory);
    private _makeExact;
    get type(): NumericType;
    get isExact(): boolean;
    get asExact(): NumericValue | undefined;
    toJSON(): Expression;
    toString(): string;
    clone(value: number | Decimal | NumericValueData): MachineNumericValue;
    get re(): number;
    get bignumRe(): Decimal | undefined;
    get numerator(): MachineNumericValue;
    get denominator(): NumericValue;
    get isNaN(): boolean;
    get isPositiveInfinity(): boolean;
    get isNegativeInfinity(): boolean;
    get isComplexInfinity(): boolean;
    get isZero(): boolean;
    isZeroWithTolerance(tolerance: number | Decimal): boolean;
    get isOne(): boolean;
    get isNegativeOne(): boolean;
    sgn(): -1 | 0 | 1 | undefined;
    N(): NumericValue;
    neg(): NumericValue;
    inv(): NumericValue;
    add(other: number | NumericValue): NumericValue;
    sub(other: NumericValue): NumericValue;
    mul(other: number | Decimal | NumericValue): NumericValue;
    div(other: SmallInteger | NumericValue): NumericValue;
    pow(exponent: number | {
        re: number;
        im: number;
    }): NumericValue;
    root(exponent: number): NumericValue;
    sqrt(): NumericValue;
    gcd(other: NumericValue): NumericValue;
    abs(): NumericValue;
    ln(base?: number): NumericValue;
    exp(): NumericValue;
    floor(): NumericValue;
    ceil(): NumericValue;
    round(): NumericValue;
    eq(other: number | NumericValue): boolean;
    lt(other: number | NumericValue): boolean | undefined;
    lte(other: number | NumericValue): boolean | undefined;
    gt(other: number | NumericValue): boolean | undefined;
    gte(other: number | NumericValue): boolean | undefined;
}
