/* 0.29.1 */
import { Decimal } from 'decimal.js';
import { Rational, SmallInteger } from '../numerics/types';
import { BigNumFactory, ExactNumericValueData, NumericValue, NumericValueFactory } from './types';
import { Expression } from '../../math-json/types';
import { NumericType } from '../../common/type/types';
/**
 * An ExactNumericValue is the sum of a Gaussian imaginary and the product of
 * a rational number and a square root:
 *
 *     a/b * sqrt(c) + ki where a, b, c and k are integers
 *
 * Note that ExactNumericValue does not "know" about BigNumericValue, but
 * BigNumericValue "knows" about ExactNumericValue.
 *
 */
export declare class ExactNumericValue extends NumericValue {
    __brand: 'ExactNumericValue';
    rational: Rational;
    radical: number;
    im: number;
    factory: NumericValueFactory;
    bignum: BigNumFactory;
    /** The caller is responsible to make sure the input is valid, i.e.
     * - rational is a fraction of integers (but it may not be reduced)
     * - radical is an integer
     */
    constructor(value: number | bigint | ExactNumericValueData, factory: NumericValueFactory, bignum: BigNumFactory);
    get type(): NumericType;
    get isExact(): boolean;
    get asExact(): NumericValue | undefined;
    toJSON(): Expression;
    clone(value: number | ExactNumericValueData): ExactNumericValue;
    /** Object.toString() */
    toString(): string;
    get sign(): -1 | 0 | 1;
    get re(): number;
    get bignumRe(): Decimal;
    get numerator(): ExactNumericValue;
    get denominator(): ExactNumericValue;
    normalize(): void;
    get isNaN(): boolean;
    get isPositiveInfinity(): boolean;
    get isNegativeInfinity(): boolean;
    get isComplexInfinity(): boolean;
    get isZero(): boolean;
    get isOne(): boolean;
    get isNegativeOne(): boolean;
    sgn(): -1 | 0 | 1 | undefined;
    N(): NumericValue;
    neg(): ExactNumericValue;
    inv(): NumericValue;
    add(other: number | NumericValue): NumericValue;
    sub(other: NumericValue): NumericValue;
    mul(other: number | Decimal | NumericValue): NumericValue;
    div(other: SmallInteger | NumericValue): NumericValue;
    pow(exponent: number | NumericValue | {
        re: number;
        im: number;
    }): NumericValue;
    root(exponent: number): NumericValue;
    sqrt(): NumericValue;
    gcd(other: NumericValue): NumericValue;
    abs(): NumericValue;
    ln(base?: number): NumericValue;
    exp(): NumericValue;
    floor(): NumericValue;
    ceil(): NumericValue;
    round(): NumericValue;
    eq(other: number | NumericValue): boolean;
    lt(other: number | NumericValue): boolean | undefined;
    lte(other: number | NumericValue): boolean | undefined;
    gt(other: number | NumericValue): boolean | undefined;
    gte(other: number | NumericValue): boolean | undefined;
    static sum(values: NumericValue[], factory: NumericValueFactory, bignumFactory: BigNumFactory): NumericValue[];
}
