/* 0.29.1 */
import type { Expression } from '../../math-json/types';
import { LatexString, SerializeLatexOptions, DelimiterScale } from './types';
import type { IndexedLatexDictionary, IndexedLatexDictionaryEntry } from './dictionary/definitions';
export declare class Serializer {
    options: Readonly<SerializeLatexOptions>;
    readonly dictionary: IndexedLatexDictionary;
    level: number;
    constructor(dictionary: IndexedLatexDictionary, options: SerializeLatexOptions);
    /**
     * Serialize the expression, and if the expression is an operator
     * of precedence less than or equal to prec, wrap it in some parens.
     * @todo: don't wrap Abs, Floor, Ceil, Delimiter
     */
    wrap(expr: Expression | null | undefined, prec?: number): string;
    /**
     * If this is a "short" expression, wrap it.
     * Do not wrap identifiers, positive numbers or functions.
     *
     * This is called by the serializer for power and division (i.e. "(a+1)/b")
     *
     */
    wrapShort(expr: Expression | null | undefined): string;
    wrapString(s: string, style: DelimiterScale, fence?: string): string;
    wrapArguments(expr: Expression): string;
    serializeSymbol(expr: Expression, def?: IndexedLatexDictionaryEntry): LatexString;
    serializeFunction(expr: Expression, def?: IndexedLatexDictionaryEntry): LatexString;
    serialize(expr: Expression | null | undefined): LatexString;
    applyFunctionStyle(expr: Expression, level: number): DelimiterScale;
    groupStyle(expr: Expression, level: number): DelimiterScale;
    rootStyle(expr: Expression, level: number): 'radical' | 'quotient' | 'solidus';
    fractionStyle(expr: Expression, level: number): 'quotient' | 'block-quotient' | 'inline-quotient' | 'inline-solidus' | 'nice-solidus' | 'reciprocal' | 'factor';
    logicStyle(expr: Expression, level: number): 'word' | 'boolean' | 'uppercase-word' | 'punctuation';
    powerStyle(expr: Expression, level: number): 'root' | 'solidus' | 'quotient';
    numericSetStyle(expr: Expression, level: number): 'compact' | 'regular' | 'interval' | 'set-builder';
}
export declare function appendLatex(src: string, s: string): string;
export declare function serializeLatex(expr: Expression | null, dict: IndexedLatexDictionary, options: Readonly<SerializeLatexOptions>): string;
