/* 0.29.1 */
import { WarningSignal } from '../../../common/signals';
import { Delimiter, EnvironmentParseHandler, ExpressionParseHandler, InfixParseHandler, LatexDictionary, LatexDictionaryEntry, LatexString, LatexToken, LibraryCategory, MatchfixParseHandler, PostfixParseHandler, Precedence, SerializeHandler } from '../types';
export type CommonEntry = {
    /** Note: a name is required if a serialize handler is provided */
    name?: string;
    serialize?: SerializeHandler;
    /** Note: not all kinds have a `latexTrigger` or `identifierTrigger`.
     * For example, matchfix operators use `openTrigger`/`closeTrigger`
     */
    latexTrigger?: LatexString;
    identifierTrigger?: string;
};
export type IndexedSymbolEntry = CommonEntry & {
    kind: 'symbol';
    precedence: Precedence;
    parse: ExpressionParseHandler;
};
/** @internal */
export declare function isIndexedSymbolEntry(entry: IndexedLatexDictionaryEntry): entry is IndexedSymbolEntry;
export type IndexedExpressionEntry = CommonEntry & {
    kind: 'expression';
    precedence: Precedence;
    parse: ExpressionParseHandler;
};
/** @internal */
export declare function isIndexedExpressionEntry(entry: IndexedLatexDictionaryEntry): entry is IndexedExpressionEntry;
/**
 * A function has the following form:
 * - a prefix such as `\mathrm` or `\operatorname`
 * - a trigger string, such as `gcd`
 * - some postfix operators such as `\prime`
 * - an optional list of arguments in an enclosure (parentheses)
 *
 * Functions of this type are indexed in the dictionary by their trigger string.
 */
export type IndexedFunctionEntry = CommonEntry & {
    kind: 'function';
    parse: ExpressionParseHandler;
};
/** @internal */
export declare function isIndexedFunctionEntry(entry: IndexedLatexDictionaryEntry): entry is IndexedFunctionEntry;
export type IndexedMatchfixEntry = CommonEntry & {
    kind: 'matchfix';
    openTrigger: Delimiter | LatexToken[];
    closeTrigger: Delimiter | LatexToken[];
    parse: MatchfixParseHandler;
};
/** @internal */
export declare function isIndexedMatchfixEntry(entry: IndexedLatexDictionaryEntry): entry is IndexedMatchfixEntry;
export type IndexedInfixEntry = CommonEntry & {
    kind: 'infix';
    associativity: 'right' | 'left' | 'none' | 'any';
    precedence: Precedence;
    parse: InfixParseHandler;
};
/** @internal */
export declare function isIndexedInfixdEntry(entry: IndexedLatexDictionaryEntry): entry is IndexedInfixEntry;
export type IndexedPrefixEntry = CommonEntry & {
    kind: 'prefix';
    precedence: Precedence;
    parse: ExpressionParseHandler;
};
/** @internal */
export declare function isIndexedPrefixedEntry(entry: IndexedLatexDictionaryEntry): entry is IndexedPostfixEntry;
export type IndexedPostfixEntry = CommonEntry & {
    kind: 'postfix';
    precedence: Precedence;
    parse: PostfixParseHandler;
};
/** @internal */
export declare function isIndexedPostfixEntry(entry: IndexedLatexDictionaryEntry): entry is IndexedPostfixEntry;
export type IndexedEnvironmentEntry = CommonEntry & {
    kind: 'environment';
    parse: EnvironmentParseHandler;
};
/** @internal */
export declare function isIndexedEnvironmentEntry(entry: IndexedLatexDictionaryEntry): entry is IndexedEnvironmentEntry;
export type IndexedLatexDictionaryEntry = IndexedExpressionEntry | IndexedFunctionEntry | IndexedSymbolEntry | IndexedMatchfixEntry | IndexedInfixEntry | IndexedPrefixEntry | IndexedPostfixEntry | IndexedEnvironmentEntry;
export type IndexedLatexDictionary = {
    ids: Map<string, IndexedLatexDictionaryEntry>;
    lookahead: number;
    defs: IndexedLatexDictionaryEntry[];
};
export declare function indexLatexDictionary(dic: Readonly<Partial<LatexDictionaryEntry>[]>, onError: (sig: WarningSignal) => void): IndexedLatexDictionary;
export declare const DEFAULT_LATEX_DICTIONARY: {
    [category in LibraryCategory]?: LatexDictionary;
};
export declare function getLatexDictionary(category?: LibraryCategory | 'all'): readonly Readonly<LatexDictionaryEntry>[];
