/* 0.29.1 */
import type { MathJsonIdentifier } from '../math-json/types';
import { BoxedExpression, CompiledType, JSSource } from './global-types';
export type CompiledOperators = Record<MathJsonIdentifier, [
    op: string,
    prec: number
]>;
export type CompiledFunction = string | ((args: ReadonlyArray<BoxedExpression>, compile: (expr: BoxedExpression) => JSSource, target: CompileTarget) => JSSource);
export type CompiledFunctions = {
    [id: MathJsonIdentifier]: CompiledFunction;
};
export type CompileTarget = {
    operators?: (op: MathJsonIdentifier) => [op: string, prec: number];
    functions?: (id: MathJsonIdentifier) => CompiledFunction | undefined;
    var: (id: MathJsonIdentifier) => string | undefined;
    string: (str: string) => string;
    number: (n: number) => string;
    ws: (s?: string) => string;
    preamble: string;
    indent: number;
};
/** This is an extension of the Function class that allows us to pass
 * a custom scope for "global" functions. */
export declare class ComputeEngineFunction extends Function {
    private sys;
    constructor(body: string, preamble?: string);
}
export declare function compileToTarget(expr: BoxedExpression, target: CompileTarget): (_?: Record<string, CompiledType>) => CompiledType;
export declare function compileToJavascript(expr: BoxedExpression, functions?: Record<MathJsonIdentifier, JSSource | Function>, vars?: Record<MathJsonIdentifier, JSSource>, imports?: unknown[], preamble?: string): (_?: Record<string, CompiledType>) => CompiledType;
export declare function compile(expr: BoxedExpression | undefined, target: CompileTarget, prec?: number): JSSource;
