/* 0.29.1 */
import type { BoxedExpression, FunctionDefinition, SemiBoxedExpression, SymbolDefinition, NumericFlags, ComputeEngine } from '../global-types';
import { Type } from '../../common/type/types';
import { NumericValue } from '../types';
export declare function isBoxedExpression(x: unknown): x is BoxedExpression;
/**
 * For any numeric result, if `bignumPreferred()` is true, calculate using
 * bignums. If `bignumPreferred()` is false, calculate using machine numbers
 */
export declare function bignumPreferred(ce: ComputeEngine): boolean;
export declare function isLatexString(s: unknown): s is string;
export declare function asLatexString(s: unknown): string | null;
export declare function hashCode(s: string): number;
export declare function normalizedUnknownsForSolve(syms: string | Iterable<string> | BoxedExpression | Iterable<BoxedExpression> | null | undefined): string[];
/** Return the local variables in the expression.
 *
 * A local variable is an identifier that is declared with a `Declare`
 * expression in a `Block` expression.
 *
 * Note that the canonical form of a `Block` expression will hoist all
 * `Declare` expressions to the top of the block. `Assign` expressions
 * of undeclared variables will also have a matching `Declare` expressions
 * hoisted.
 *
 */
export declare function isRelationalOperator(name: BoxedExpression | string): boolean;
export declare function isInequalityOperator(operator: string): boolean;
export declare function isEquationOperator(operator: string): boolean;
export declare function isInequality(expr: BoxedExpression): boolean;
export declare function isEquation(expr: BoxedExpression): boolean;
/**
 * Return a multiple of the imaginary unit, e.g.
 * - 'ImaginaryUnit'  -> 1
 * - ['Negate', 'ImaginaryUnit']  -> -1
 * - ['Negate', ['Multiply', 3, 'ImaginaryUnit']] -> -3
 * - ['Multiply', 5, 'ImaginaryUnit'] -> 5
 * - ['Multiply', 'ImaginaryUnit', 5] -> 5
 * - ['Divide', 'ImaginaryUnit', 2] -> 0.5
 *
 */
export declare function getImaginaryFactor(expr: number | BoxedExpression): BoxedExpression | undefined;
export declare function normalizeFlags(flags: Partial<NumericFlags> | undefined): NumericFlags | undefined;
export declare function isSymbolDefinition(def: any): def is SymbolDefinition;
export declare function isFunctionDefinition(def: any): def is FunctionDefinition;
export declare function semiCanonical(ce: ComputeEngine, xs: ReadonlyArray<SemiBoxedExpression>): ReadonlyArray<BoxedExpression>;
export declare function canonical(ce: ComputeEngine, xs: ReadonlyArray<SemiBoxedExpression>): ReadonlyArray<BoxedExpression>;
export declare function domainToType(expr: BoxedExpression): Type;
/**
 * Return the angle in the range [0, 2π) that is equivalent to the given angle.
 *
 * @param x
 * @returns
 */
export declare function canonicalAngle(x: BoxedExpression | undefined): BoxedExpression | undefined;
export declare function getPiTerm(expr: BoxedExpression): [k: NumericValue, t: NumericValue];
