/* 0.29.1 */
import type { BoxedRule, BoxedRuleSet, BoxedSubstitution, ComputeEngine, Rule, RuleStep, RuleSteps, BoxedExpression, ReplaceOptions } from '../global-types';
export declare const ConditionParent: {
    boolean: string;
    string: string;
    expression: string;
    numeric: string;
    number: string;
    symbol: string;
    complex: string;
    imaginary: string;
    real: string;
    notreal: string;
    integer: string;
    rational: string;
    irrational: string;
    notzero: string;
    notone: string;
    finite: string;
    infinite: string;
    positive: string;
    negative: string;
    nonnegative: string;
    nonpositive: string;
    even: string;
    odd: string;
    prime: string;
    composite: string;
    constant: string;
    variable: string;
    function: string;
    operator: string;
    relation: string;
    equation: string;
    inequality: string;
    collection: string;
    list: string;
    set: string;
    tuple: string;
    single: string;
    pair: string;
    triple: string;
    tensor: string;
    vector: string;
    matrix: string;
    scalar: string;
    unit: string;
    dimension: string;
    angle: string;
    polynomial: string;
};
export declare const CONDITIONS: {
    boolean: (x: BoxedExpression) => boolean;
    string: (x: BoxedExpression) => boolean;
    number: (x: BoxedExpression) => boolean;
    symbol: (x: BoxedExpression) => boolean;
    expression: (x: BoxedExpression) => boolean;
    numeric: (x: BoxedExpression) => boolean;
    integer: (x: BoxedExpression) => boolean;
    rational: (x: BoxedExpression) => boolean;
    irrational: (x: BoxedExpression) => boolean;
    real: (x: BoxedExpression) => boolean;
    notreal: (x: BoxedExpression) => boolean;
    complex: (x: BoxedExpression) => boolean;
    imaginary: (x: BoxedExpression) => boolean;
    positive: (x: BoxedExpression) => boolean;
    negative: (x: BoxedExpression) => boolean;
    nonnegative: (x: BoxedExpression) => boolean;
    nonpositive: (x: BoxedExpression) => boolean;
    even: (x: BoxedExpression) => boolean;
    odd: (x: BoxedExpression) => boolean;
    prime: (x: BoxedExpression) => boolean;
    composite: (x: BoxedExpression) => boolean;
    notzero: (x: BoxedExpression) => boolean;
    notone: (x: BoxedExpression) => boolean;
    finite: (x: BoxedExpression) => boolean;
    infinite: (x: BoxedExpression) => boolean;
    constant: (x: BoxedExpression) => boolean;
    variable: (x: BoxedExpression) => boolean;
    function: (x: BoxedExpression) => boolean;
    relation: (x: BoxedExpression) => boolean;
    equation: (x: BoxedExpression) => boolean;
    inequality: (x: BoxedExpression) => boolean;
    collection: (x: BoxedExpression) => boolean;
    list: (x: BoxedExpression) => boolean;
    set: (x: BoxedExpression) => boolean;
    tuple: (x: BoxedExpression) => boolean;
    single: (x: BoxedExpression) => boolean;
    pair: (x: BoxedExpression) => boolean;
    triple: (x: BoxedExpression) => boolean;
    scalar: (x: BoxedExpression) => boolean;
    tensor: (x: BoxedExpression) => boolean;
    vector: (x: BoxedExpression) => boolean;
    matrix: (x: BoxedExpression) => boolean;
    unit: (x: BoxedExpression) => boolean;
    dimension: (x: BoxedExpression) => boolean;
    angle: (x: BoxedExpression) => boolean;
    polynomial: (x: BoxedExpression) => boolean;
};
export declare function checkConditions(x: BoxedExpression, conditions: string[]): boolean;
/**
 * Create a boxed rule set from a collection of non-boxed rules
 */
export declare function boxRules(ce: ComputeEngine, rs: Rule | ReadonlyArray<Rule | BoxedRule> | BoxedRuleSet | undefined | null, options?: {
    canonical?: boolean;
}): BoxedRuleSet;
/**
 * Apply a rule to an expression, assuming an incoming substitution
 * @param rule the rule to apply
 * @param expr the expression to apply the rule to
 * @param substitution an incoming substitution
 * @param options
 * @returns A transformed expression, if the rule matched. `null` otherwise.
 */
export declare function applyRule(rule: Readonly<BoxedRule>, expr: BoxedExpression, substitution: BoxedSubstitution, options?: Readonly<Partial<ReplaceOptions>>): RuleStep | null;
/**
 * Apply the rules in the ruleset and return a modified expression
 * and the set of rules that were applied.
 *
 * The `replace` function can be used to apply a rule to a non-canonical
 * expression. @fixme: account for options.canonical
 *
 */
export declare function replace(expr: BoxedExpression, rules: Rule | (Rule | BoxedRule)[] | BoxedRuleSet, options?: Partial<ReplaceOptions>): RuleSteps;
/**
 * For each rules in the rule set that match, return the `replace` of the rule
 *
 * @param rules
 */
export declare function matchAnyRules(expr: BoxedExpression, rules: BoxedRuleSet, sub: BoxedSubstitution, options?: Partial<ReplaceOptions>): BoxedExpression[];
