/* 0.29.1 */
import type { BoxedExpression, ComputeEngine } from '../global-types';
export declare function canonicalNegate(expr: BoxedExpression): BoxedExpression;
/**
 * Distribute `Negate` (multiply by -1) if expr is a number literal, an
 * addition or multiplication or another `Negate`.
 *
 * It is important to do all these to handle cases like
 * `-3x` -> ["Negate, ["Multiply", 3, "x"]] -> ["Multiply, -3, x]
 */
export declare function negate(expr: BoxedExpression): BoxedExpression;
export declare function negateProduct(ce: ComputeEngine, args: ReadonlyArray<BoxedExpression>): BoxedExpression;
