/* 0.29.1 */
import type { BoxedExpression } from '../global-types';
/**
 *
 * Make all the arguments canonical.
 *
 * "Lift" Sequence expressions to the top level.
 * e.g. `["Add", 1, ["Sequence", 2, 3]]` -> `["Add", 1, 2, 3]`
 *
 * Additionally, if an operator is provided, also lift nested expressions
 * with the same operator.
 *  e.g. `["f", a, ["f", b, c]]` -> `["f", a, b, c]`
 *
 * Note: *not* recursive
 */
export declare function flatten<T extends ReadonlyArray<BoxedExpression> | BoxedExpression[]>(ops: T, operator?: string): T;
/**
 * Flatten the arguments.
 * @fixme replace with just flatten.
 * @fixme consider adding flatternSort()
 */
export declare function flattenOps<T extends ReadonlyArray<BoxedExpression> | BoxedExpression[]>(ops: T, operator: string): T;
/**
 * @todo: this function should probably not be recursive. As it, it is semi-recursive.
 */
export declare function flattenSequence(xs: ReadonlyArray<BoxedExpression>): ReadonlyArray<BoxedExpression>;
