/* 0.29.1 */
import type { ComputeEngine, BoxedExpression } from '../global-types';
export declare function expandProducts(ce: ComputeEngine, ops: ReadonlyArray<BoxedExpression>): BoxedExpression | null;
export declare function choose(n: number, k: number): number;
/** Attempt to transform the expression (h, ops) into a sum */
export declare function expandFunction(ce: ComputeEngine, h: string, ops: ReadonlyArray<BoxedExpression>): BoxedExpression | null;
/** Apply the distributive law if the expression is a product of sums.
 * For example, a(b + c) = ab + ac
 * Expand the expression if it is a power of a sum.
 * Expand the terms of the expression if it is a sum or negate.
 * If the expression is a fraction, expand the numerator.
 * If the exression is a relational operator, expand the operands.
 * Return null if the expression cannot be expanded.
 */
export declare function expand(expr: BoxedExpression | undefined): BoxedExpression | null;
/**
 * Recursive expand of all terms in the expression.
 *
 * `expand()` only expands the top level of the expression.
 */
export declare function expandAll(expr: BoxedExpression): BoxedExpression | null;
