/* 0.29.1 */
import type { BoxedExpression, SemiBoxedExpression, SymbolDefinition, BoxedSymbolDefinition, CollectionHandlers, ComputeEngine, NumericFlags, RuntimeScope, Sign } from '../global-types';
import { Type, TypeString } from '../../common/type/types';
import { BoxedType } from '../../common/type/boxed-type';
/**
 * ### THEORY OF OPERATIONS
 *
 * - The value or type of a constant cannot be changed.
 *
 * - If set explicitly, the value is the source of truth: it overrides any
 *   flags.
 *
 * - Once the type has been set, it can only be changed from a numeric type
 *   to another numeric type (some expressions may have been validated with
 *   assumptions that the just a number).
 *
 * - When the type is changed, the value is preserved if it is compatible
 *   with the new type, otherwise it is reset to no value. Flags are adjusted
 *   to match the type (discarded if not a numeric type).
 *
 * - When the value is changed, the type is unaffected. If the value is not
 *   compatible with the type (setting a def with a numeric type to a value
 *   of `True` for example), the value is discarded.
 *
 * - When getting a flag, if a value is available, it is the source of truth.
 *   Otherwise, the stored flags are (the stored flags are also set when the
 *   type is changed)
 *
 */
export declare class _BoxedSymbolDefinition implements BoxedSymbolDefinition {
    readonly name: string;
    wikidata?: string;
    description?: string | string[];
    url?: string;
    private _engine;
    readonly scope: RuntimeScope | undefined;
    private _defValue?;
    private _value;
    private _type;
    inferredType: boolean;
    constant: boolean;
    holdUntil: 'never' | 'evaluate' | 'N';
    private _flags;
    eq?: (a: BoxedExpression) => boolean | undefined;
    neq?: (a: BoxedExpression) => boolean | undefined;
    cmp?: (a: BoxedExpression) => '=' | '>' | '<' | undefined;
    collection?: Partial<CollectionHandlers>;
    constructor(ce: ComputeEngine, name: string, def: SymbolDefinition);
    get isFunction(): boolean;
    get isConstant(): boolean;
    /** The symbol was previously inferred, but now it has a declaration. Update the def accordingly (we can't replace defs, as other expressions may be referencing them) */
    update(def: SymbolDefinition): void;
    reset(): void;
    get value(): BoxedExpression | undefined;
    set value(val: SemiBoxedExpression | number | undefined);
    get type(): BoxedType;
    set type(type: Type | TypeString | BoxedType);
    get sgn(): Sign | undefined;
    set sgn(val: Sign | undefined);
    get even(): boolean | undefined;
    set even(val: boolean | undefined);
    get odd(): boolean | undefined;
    set odd(val: boolean | undefined);
    updateFlags(flags: Partial<NumericFlags>): void;
}
