/* 0.29.1 */
import type { BoxedExpression, PatternMatchOptions, BoxedSubstitution, ComputeEngine, Metadata } from '../global-types';
import { _BoxedExpression } from './abstract-boxed-expression';
import { BoxedType } from '../../common/type/boxed-type';
/**
 * BoxedString
 *
 */
export declare class BoxedString extends _BoxedExpression {
    private readonly _string;
    constructor(ce: ComputeEngine, expr: string, metadata?: Metadata);
    get json(): string;
    get hash(): number;
    get operator(): string;
    get isPure(): boolean;
    get isCanonical(): boolean;
    set isCanonical(_va: boolean);
    get type(): BoxedType;
    get complexity(): number;
    get string(): string;
    match(pattern: BoxedExpression, _options?: PatternMatchOptions): BoxedSubstitution | null;
    get isCollection(): boolean;
    contains(rhs: BoxedExpression): boolean;
    get size(): number;
    each(start?: number, count?: number): Iterator<BoxedExpression, undefined>;
    at(index: number): BoxedExpression | undefined;
    get(key: string | BoxedExpression): BoxedExpression | undefined;
    indexOf(expr: BoxedExpression): number;
}
