/* 0.29.1 */
import { Complex } from 'complex-esm';
import { Decimal } from 'decimal.js';
import type { Expression, MathJsonNumber } from '../../math-json';
import type { Rational, SmallInteger } from '../numerics/types';
import { ExactNumericValueData, NumericValue, NumericValueData } from '../numeric-value/types';
import { _BoxedExpression } from './abstract-boxed-expression';
import { BoxedType } from '../../common/type/boxed-type';
import type { BoxedRuleSet, BoxedSubstitution, CanonicalOptions, EvaluateOptions, ComputeEngine, Metadata, Rule, Sign, Substitution, BoxedExpression, PatternMatchOptions, ReplaceOptions, SimplifyOptions } from '../global-types';
/**
 * BoxedNumber
 *
 */
export declare class BoxedNumber extends _BoxedExpression {
    protected readonly _value: SmallInteger | NumericValue;
    private _hash;
    /**
     * By the time the constructor is called, the `value` should have been
     * screened for cases where it's a well-known value (0, NaN, +Infinity,
     * etc...) or non-normal (complex number with im = 0, rational with
     * denom = 1, etc...).
     *
     * This is done in `ce.number()`. In general, use `ce.number()` rather
     * than calling this constructor directly.
     *
     * We may store as a machine number if a Decimal is passed that is in machine
     * range
     */
    constructor(ce: ComputeEngine, value: SmallInteger | NumericValueData | ExactNumericValueData | NumericValue, options?: {
        metadata?: Metadata;
        canonical?: boolean;
    });
    get hash(): number;
    get json(): Expression;
    get operator(): string;
    get isPure(): boolean;
    get isCanonical(): boolean;
    set isCanonical(val: boolean);
    get complexity(): number;
    get numericValue(): number | NumericValue;
    get isNumberLiteral(): boolean;
    get re(): number;
    get im(): number;
    get bignumRe(): Decimal | undefined;
    get bignumIm(): Decimal | undefined;
    neg(): BoxedExpression;
    inv(): BoxedExpression;
    abs(): BoxedExpression;
    add(rhs: number | BoxedExpression): BoxedExpression;
    mul(rhs: NumericValue | number | BoxedExpression): BoxedExpression;
    div(rhs: number | BoxedExpression): BoxedExpression;
    pow(exp: number | BoxedExpression): BoxedExpression;
    root(exp: number | BoxedExpression): BoxedExpression;
    sqrt(): BoxedExpression;
    ln(semiBase?: number | BoxedExpression): BoxedExpression;
    get type(): BoxedType;
    get sgn(): Sign | undefined;
    get numerator(): BoxedExpression;
    get denominator(): BoxedExpression;
    get numeratorDenominator(): [BoxedExpression, BoxedExpression];
    subs(sub: Substitution, options?: {
        canonical?: CanonicalOptions;
    }): BoxedExpression;
    replace(rules: BoxedRuleSet | Rule | Rule[], options?: Partial<ReplaceOptions>): BoxedExpression | null;
    match(pattern: BoxedExpression, options?: PatternMatchOptions): BoxedSubstitution | null;
    /** x > 0, same as `isGreater(0)` */
    get isPositive(): boolean | undefined;
    /** x >= 0, same as `isGreaterEqual(0)` */
    get isNonNegative(): boolean | undefined;
    /** x < 0, same as `isLess(0)` */
    get isNegative(): boolean | undefined;
    /** x <= 0, same as `isLessEqual(0)` */
    get isNonPositive(): boolean | undefined;
    get isOdd(): boolean | undefined;
    get isEven(): boolean | undefined;
    get isInfinity(): boolean;
    get isNaN(): boolean;
    get isFinite(): boolean;
    get isNumber(): true;
    get isInteger(): boolean;
    get isRational(): boolean;
    get isReal(): boolean;
    is(rhs: any): boolean;
    get canonical(): BoxedExpression;
    get isStructural(): boolean;
    get structural(): BoxedExpression;
    toNumericValue(): [NumericValue, BoxedExpression];
    simplify(options?: Partial<SimplifyOptions>): BoxedExpression;
    evaluate(options?: Partial<EvaluateOptions>): BoxedExpression;
    N(): BoxedExpression;
}
export declare function canonicalNumber(ce: ComputeEngine, value: number | bigint | string | Decimal | Complex | Rational | NumericValue | MathJsonNumber): number | NumericValue;
