/* 0.29.1 */
import type { Expression } from '../../math-json/types';
import type { SimplifyOptions, ReplaceOptions, PatternMatchOptions, BoxedExpression, BoxedBaseDefinition, BoxedFunctionDefinition, BoxedRuleSet, BoxedSubstitution, CanonicalOptions, EvaluateOptions, ComputeEngine, Metadata, Rule, RuntimeScope, Sign, Substitution } from '../global-types';
import { NumericValue } from '../numeric-value/types';
import { _BoxedExpression } from './abstract-boxed-expression';
import { Type } from '../../common/type/types';
import { BoxedType } from '../../common/type/boxed-type';
/**
 * A boxed function represent an expression that can be represented by a
 * function call.
 *
 * It is composed of an operator (the name of the function) and a list of
 * arguments.
 *
 * It has a definition associated with it, based on the operator.
 * The definition contains the signature of the function, and the
 * implementation of the function.
 *
 */
export declare class BoxedFunction extends _BoxedExpression {
    private readonly _name;
    private readonly _ops;
    private _canonical;
    private _scope;
    _def: BoxedFunctionDefinition | undefined;
    private _isPure;
    private _isStructural;
    private _hash;
    private _value;
    private _valueN;
    private _sgn;
    private _type;
    constructor(ce: ComputeEngine, name: string, ops: ReadonlyArray<BoxedExpression>, options?: {
        metadata?: Metadata;
        canonical?: boolean;
        structural?: boolean;
    });
    get hash(): number;
    infer(t: Type): boolean;
    bind(): void;
    reset(): void;
    get isCanonical(): boolean;
    set isCanonical(val: boolean);
    get isPure(): boolean;
    /** The value of the function is constant if the function is
     * pure, and all its arguments are constant.
     */
    get isConstant(): boolean;
    get json(): Expression;
    get scope(): RuntimeScope | null;
    get operator(): string;
    get ops(): ReadonlyArray<BoxedExpression>;
    get nops(): number;
    get op1(): BoxedExpression;
    get op2(): BoxedExpression;
    get op3(): BoxedExpression;
    get isValid(): boolean;
    get canonical(): BoxedExpression;
    get structural(): BoxedExpression;
    get isStructural(): boolean;
    toNumericValue(): [NumericValue, BoxedExpression];
    subs(sub: Substitution, options?: {
        canonical?: CanonicalOptions;
    }): BoxedExpression;
    replace(rules: BoxedRuleSet | Rule | Rule[], options?: Partial<ReplaceOptions>): BoxedExpression | null;
    match(pattern: BoxedExpression, options?: PatternMatchOptions): BoxedSubstitution | null;
    has(v: string | string[]): boolean;
    get sgn(): Sign | undefined;
    get isNaN(): boolean | undefined;
    get isInfinity(): boolean | undefined;
    get isFinite(): boolean | undefined;
    get isOne(): boolean | undefined;
    get isNegativeOne(): boolean | undefined;
    get isPositive(): boolean | undefined;
    get isNonNegative(): boolean | undefined;
    get isNegative(): boolean | undefined;
    get isNonPositive(): boolean | undefined;
    get numerator(): BoxedExpression;
    get denominator(): BoxedExpression;
    get numeratorDenominator(): [BoxedExpression, BoxedExpression];
    neg(): BoxedExpression;
    inv(): BoxedExpression;
    abs(): BoxedExpression;
    add(rhs: number | BoxedExpression): BoxedExpression;
    mul(rhs: NumericValue | number | BoxedExpression): BoxedExpression;
    div(rhs: number | BoxedExpression): BoxedExpression;
    pow(exp: number | BoxedExpression): BoxedExpression;
    root(exp: number | BoxedExpression): BoxedExpression;
    sqrt(): BoxedExpression;
    ln(semiBase?: number | BoxedExpression): BoxedExpression;
    get complexity(): number | undefined;
    get baseDefinition(): BoxedBaseDefinition | undefined;
    get functionDefinition(): BoxedFunctionDefinition | undefined;
    get isNumber(): boolean | undefined;
    get isInteger(): boolean | undefined;
    get isRational(): boolean | undefined;
    get isReal(): boolean | undefined;
    get isFunctionExpression(): boolean;
    /** The type of the value of the function */
    get type(): BoxedType;
    simplify(options?: Partial<SimplifyOptions>): BoxedExpression;
    evaluate(options?: Partial<EvaluateOptions>): BoxedExpression;
    evaluateAsync(options?: Partial<EvaluateOptions>): Promise<BoxedExpression>;
    N(): BoxedExpression;
    solve(vars?: Iterable<string> | string | BoxedExpression | Iterable<BoxedExpression>): null | ReadonlyArray<BoxedExpression>;
    get isCollection(): boolean;
    contains(rhs: BoxedExpression): boolean;
    get size(): number;
    each(start?: number, count?: number): Iterator<BoxedExpression, undefined>;
    at(index: number): BoxedExpression | undefined;
    get(index: BoxedExpression | string): BoxedExpression | undefined;
    indexOf(expr: BoxedExpression): number;
    subsetOf(rhs: BoxedExpression, strict: boolean): boolean;
    _computeValue(options?: Partial<EvaluateOptions>): () => BoxedExpression;
    _computeValueAsync(options?: Partial<EvaluateOptions>): () => Promise<BoxedExpression>;
}
