/* 0.29.1 */
import { Type, TypeString } from '../../common/type/types';
import { OneOf } from '../../common/one-of';
import { BoxedType } from '../../common/type/boxed-type';
import type { FunctionDefinition, BoxedExpression, BoxedFunctionDefinition, CollectionHandlers, CompiledExpression, EvaluateOptions, ComputeEngine, RuntimeScope, Sign } from '../global-types';
export declare class _BoxedFunctionDefinition implements BoxedFunctionDefinition {
    engine: ComputeEngine;
    scope: RuntimeScope;
    name: string;
    description?: string | string[];
    wikidata?: string;
    threadable: boolean;
    associative: boolean;
    commutative: boolean;
    commutativeOrder: ((a: BoxedExpression, b: BoxedExpression) => number) | undefined;
    idempotent: boolean;
    involution: boolean;
    pure: boolean;
    complexity: number;
    lazy: boolean;
    signature: BoxedType;
    inferredSignature: boolean;
    type?: (ops: ReadonlyArray<BoxedExpression>, options: {
        engine: ComputeEngine;
    }) => BoxedType | Type | TypeString | undefined;
    sgn?: (ops: ReadonlyArray<BoxedExpression>, options: {
        engine: ComputeEngine;
    }) => Sign | undefined;
    eq?: (a: BoxedExpression, b: BoxedExpression) => boolean | undefined;
    neq?: (a: BoxedExpression, b: BoxedExpression) => boolean | undefined;
    even?: (ops: ReadonlyArray<BoxedExpression>, options: {
        engine: ComputeEngine;
    }) => boolean | undefined;
    canonical?: (ops: ReadonlyArray<BoxedExpression>, options: {
        engine: ComputeEngine;
    }) => BoxedExpression | null;
    evaluate?: (ops: ReadonlyArray<BoxedExpression>, options: Partial<EvaluateOptions> & {
        engine: ComputeEngine;
    }) => BoxedExpression | undefined;
    evaluateAsync?: (ops: ReadonlyArray<BoxedExpression>, options?: Partial<EvaluateOptions> & {
        engine?: ComputeEngine;
    }) => Promise<BoxedExpression | undefined>;
    evalDimension?: (ops: ReadonlyArray<BoxedExpression>, options: {
        engine: ComputeEngine;
    }) => BoxedExpression;
    compile?: (expr: BoxedExpression) => CompiledExpression;
    collection?: Partial<CollectionHandlers>;
    constructor(ce: ComputeEngine, name: string, def: FunctionDefinition);
    infer(sig: Type): void;
    update(def: FunctionDefinition): void;
    reset(): void;
}
export declare function makeFunctionDefinition(engine: ComputeEngine, name: string, def: OneOf<[FunctionDefinition | BoxedFunctionDefinition]>): BoxedFunctionDefinition;
export declare function isBoxedFunctionDefinition(x: any): x is BoxedFunctionDefinition;
