/* 0.29.1 */
import { Complex } from 'complex-esm';
import { Decimal } from 'decimal.js';
import type { SemiBoxedExpression, BoxedExpression, CanonicalOptions, ComputeEngine, Metadata } from '../global-types';
import { MathJsonIdentifier } from '../../math-json/types';
import { NumericValue } from '../numeric-value/types';
/**
 * Given a name and a set of arguments, return a boxed function expression.
 *
 * If available, preserve LaTeX and wikidata metadata in the boxed expression.
 *
 * Note that `boxFunction()` should only be called from `ce.function()`
 */
export declare function boxFunction(ce: ComputeEngine, name: MathJsonIdentifier, ops: readonly SemiBoxedExpression[], options?: {
    metadata?: Metadata;
    canonical?: CanonicalOptions;
    structural?: boolean;
}): BoxedExpression;
/**
 * Notes about the boxed form:
 *
 * [1] Expression with an operator of `Number`, `String`, `Symbol` and `Dictionary`
 *      are converted to the corresponding atomic expression.
 *
 * [2] Expressions with an operator of `Complex` are converted to a (complex) number
 *     or a `Add`/`Multiply` expression.
 *
 *     The precedence of `Complex` (for serialization) is sometimes the
 *     precedence of `Add` (when re and im != 0), sometimes the precedence of
 *    `Multiply` (when im or re === 0). Using a number or an explicit
 *    `Add`/`Multiply` expression avoids this ambiguity.
 *
 * [3] An expression with a `Rational` operator is converted to a rational
 *    number if possible, to a `Divide` otherwise.
 *
 * [4] A `Negate` function applied to a number literal is converted to a number.
 *
 *     Note that `Negate` is only distributed over addition. In practice, having
 * `Negate` factored on multiply/divide is more useful to detect patterns.
 *
 * Note that this function should only be called from `ce.box()`
 *
 */
export declare function box(ce: ComputeEngine, expr: null | undefined | NumericValue | SemiBoxedExpression, options?: {
    canonical?: CanonicalOptions;
    structural?: boolean;
}): BoxedExpression;
export declare function toBigint(x: Complex | Decimal | SemiBoxedExpression): bigint | null;
