/* 0.29.1 */
import { Decimal } from 'decimal.js';
import { Expression, MathJsonIdentifier } from '../../math-json/types';
import type { Type, TypeString } from '../../common/type/types';
import { BoxedType } from '../../common/type/boxed-type';
import type { BoxedSubstitution, Metadata, RuntimeScope, Substitution, CanonicalOptions, BoxedRuleSet, Rule, BoxedBaseDefinition, BoxedSymbolDefinition, BoxedFunctionDefinition, EvaluateOptions, CompiledType, Sign, BoxedExpression, JsonSerializationOptions, PatternMatchOptions, SimplifyOptions, TensorData, ComputeEngine } from '../global-types';
import type { NumericValue } from '../numeric-value/types';
import type { SmallInteger } from '../numerics/types';
import type { LatexString, SerializeLatexOptions } from '../latex-syntax/types';
import { AsciiMathOptions } from './ascii-math';
/**
 * _BoxedExpression
 */
export declare abstract class _BoxedExpression implements BoxedExpression {
    abstract readonly hash: number;
    abstract readonly json: Expression;
    abstract readonly operator: string;
    /** @deprecated */
    get head(): string;
    abstract get isCanonical(): boolean;
    abstract set isCanonical(_val: boolean);
    abstract match(pattern: BoxedExpression, options?: PatternMatchOptions): BoxedSubstitution | null;
    readonly engine: ComputeEngine;
    /** Verbatim LaTeX, obtained from a source, i.e. from parsing,
     *  not generated synthetically
     */
    verbatimLatex?: string;
    constructor(ce: ComputeEngine, metadata?: Metadata);
    isSame(rhs: BoxedExpression): boolean;
    isEqual(rhs: number | BoxedExpression): boolean | undefined;
    isLess(_rhs: number | BoxedExpression): boolean | undefined;
    isLessEqual(_rhs: number | BoxedExpression): boolean | undefined;
    isGreater(_rhs: number | BoxedExpression): boolean | undefined;
    isGreaterEqual(_rhs: number | BoxedExpression): boolean | undefined;
    /**
     *
     * `Object.valueOf()`: return a JavaScript primitive value for the expression
     *
     * Primitive values are: boolean, number, bigint, string, null, undefined
     *
     */
    valueOf(): number | object | string | boolean;
    toAsciiMath(options?: Partial<AsciiMathOptions>): string;
    /** Object.toString() */
    toString(): string;
    print(): void;
    [Symbol.toPrimitive](hint: 'number' | 'string' | 'default'): number | string | null;
    /** Called by `JSON.stringify()` when serializing to json.
     *
     * Note: this is a standard method of JavaScript objects.
     *
     */
    toJSON(): Expression;
    toMathJson(options?: Readonly<Partial<JsonSerializationOptions>>): Expression;
    toLatex(options?: Partial<SerializeLatexOptions>): LatexString;
    toNumericValue(): [NumericValue, BoxedExpression];
    get scope(): RuntimeScope | null;
    is(rhs: any): boolean;
    get canonical(): BoxedExpression;
    get structural(): BoxedExpression;
    get isStructural(): boolean;
    get latex(): LatexString;
    set latex(val: LatexString);
    get symbol(): string | null;
    get tensor(): null | TensorData<'expression'>;
    get string(): string | null;
    getSubexpressions(operator: MathJsonIdentifier): ReadonlyArray<BoxedExpression>;
    get subexpressions(): ReadonlyArray<BoxedExpression>;
    get symbols(): ReadonlyArray<string>;
    get unknowns(): ReadonlyArray<string>;
    get freeVariables(): ReadonlyArray<string>;
    get errors(): ReadonlyArray<BoxedExpression>;
    get ops(): null | ReadonlyArray<BoxedExpression>;
    get nops(): SmallInteger;
    get op1(): BoxedExpression;
    get op2(): BoxedExpression;
    get op3(): BoxedExpression;
    get isValid(): boolean;
    get isPure(): boolean;
    /** Literals (number, string, boolean) are constants. Some symbols
     * may also be constants (e.g. Pi, E, True, False). Expressions of constant
     * symbols are also constants (if the function is pure).
     */
    get isConstant(): boolean;
    get isNaN(): boolean | undefined;
    get isInfinity(): boolean | undefined;
    get isFinite(): boolean | undefined;
    get isEven(): boolean | undefined;
    get isOdd(): boolean | undefined;
    get numericValue(): number | NumericValue | null;
    get isNumberLiteral(): boolean;
    get isFunctionExpression(): boolean;
    get re(): number;
    get im(): number;
    get bignumRe(): Decimal | undefined;
    get bignumIm(): Decimal | undefined;
    get numerator(): BoxedExpression;
    get denominator(): BoxedExpression;
    get numeratorDenominator(): [BoxedExpression, BoxedExpression];
    neg(): BoxedExpression;
    inv(): BoxedExpression;
    abs(): BoxedExpression;
    add(rhs: number | BoxedExpression): BoxedExpression;
    sub(rhs: BoxedExpression): BoxedExpression;
    mul(rhs: NumericValue | number | BoxedExpression): BoxedExpression;
    div(rhs: number | BoxedExpression): BoxedExpression;
    pow(exp: number | BoxedExpression): BoxedExpression;
    root(exp: number | BoxedExpression): BoxedExpression;
    sqrt(): BoxedExpression;
    ln(base?: number | BoxedExpression): BoxedExpression;
    get sgn(): Sign | undefined;
    get shape(): number[];
    get rank(): number;
    subs(_sub: Substitution, options?: {
        canonical?: CanonicalOptions;
    }): BoxedExpression;
    map(fn: (x: BoxedExpression) => BoxedExpression, options?: {
        canonical: CanonicalOptions;
        recursive?: boolean;
    }): BoxedExpression;
    solve(_vars?: Iterable<string> | string | BoxedExpression | Iterable<BoxedExpression>): null | ReadonlyArray<BoxedExpression>;
    replace(_rules: BoxedRuleSet | Rule | Rule[]): null | BoxedExpression;
    has(_v: string | string[]): boolean;
    get isPositive(): boolean | undefined;
    get isNonNegative(): boolean | undefined;
    get isNegative(): boolean | undefined;
    get isNonPositive(): boolean | undefined;
    get description(): string[] | undefined;
    get url(): string | undefined;
    get wikidata(): string | undefined;
    get complexity(): number | undefined;
    get baseDefinition(): BoxedBaseDefinition | undefined;
    get symbolDefinition(): BoxedSymbolDefinition | undefined;
    get functionDefinition(): BoxedFunctionDefinition | undefined;
    infer(_t: Type): boolean;
    bind(): void;
    reset(): void;
    get value(): number | boolean | string | object | undefined;
    set value(_value: BoxedExpression | number | boolean | string | number[] | undefined);
    get type(): BoxedType;
    set type(_type: Type | TypeString | BoxedType);
    get isNumber(): boolean | undefined;
    get isInteger(): boolean | undefined;
    get isRational(): boolean | undefined;
    get isReal(): boolean | undefined;
    simplify(_options?: Partial<SimplifyOptions>): BoxedExpression;
    expand(): BoxedExpression;
    evaluate(_options?: Partial<EvaluateOptions>): BoxedExpression;
    evaluateAsync(_options?: Partial<EvaluateOptions>): Promise<BoxedExpression>;
    N(): BoxedExpression;
    compile(options?: {
        to?: 'javascript';
        functions?: Record<MathJsonIdentifier, string | ((...any: any[]) => any)>;
        vars?: Record<MathJsonIdentifier, string>;
        imports?: ((...any: any[]) => any)[];
        preamble?: string;
    }): (args: Record<string, any>) => CompiledType;
    get isCollection(): boolean;
    contains(_rhs: BoxedExpression): boolean;
    subsetOf(_target: BoxedExpression, _strict: boolean): boolean;
    get size(): number;
    each(_start?: number, _count?: number): Iterator<BoxedExpression, undefined>;
    at(_index: number): BoxedExpression | undefined;
    get(_key: string | BoxedExpression): BoxedExpression | undefined;
    indexOf(_expr: BoxedExpression): number;
}
export declare function getSubexpressions(expr: BoxedExpression, name: MathJsonIdentifier): ReadonlyArray<BoxedExpression>;
