/* 0.29.1 */
export declare class CancellationError<T = unknown> extends Error {
    cause: unknown;
    value: T;
    constructor({ message, value, cause, }?: {
        message?: string;
        value?: T;
        cause?: unknown;
    });
}
/**
 * Executes a generator asynchronously with timeout and abort signal support.
 *
 * @param gen - The generator to execute.
 * @param timeLimitMs - The maximum time (in milliseconds) allowed for execution.
 * @param signal - An AbortSignal to cancel execution prematurely.
 * @returns The final value produced by the generator.
 * @throws CancellationError if the operation is canceled or times out.
 */
export declare function runAsync<T>(gen: Generator<T>, timeLimitMs: number, signal?: AbortSignal): Promise<T>;
export declare function run<T>(gen: Generator<T>, timeLimitMs: number): T;
