<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\School;
use App\Models\Grade;
use App\Models\SchoolClass;
use App\Models\ExamParticipant;

class DemoDataSeeder extends Seeder
{
    public function run(): void
    {
        $school = School::firstOrCreate(
            ['kode' => 'SMK-DEMO'],
            [
                'nama' => 'SMK Demo',
                'alamat' => 'Kota Demo',
                'kepsek' => 'Kepsek Demo',
                'kota' => 'Demo City',
                'provinsi' => 'Demo Province',
                'status' => 'negeri',
            ]
        );

        $grade = Grade::firstOrCreate([
            'id_school' => $school->id,
            'grade' => 'X',
        ]);

        $class = SchoolClass::firstOrCreate([
            'id_school' => $school->id,
            'id_grade' => $grade->id,
            'name' => 'X IPA 1',
        ]);

        $className = $class->name;

        // Buat 50 peserta ujian dengan token 5 digit
        $base = 100000000;
        for ($i = 1; $i <= 50; $i++) {
            $nisn = (string)($base + $i);
            ExamParticipant::updateOrCreate(
                ['nisn' => $nisn],
                [
                    'nama' => 'Peserta ' . $i,
                    'id_kelas' => $class->id,
                    'name_class' => $className,
                    'jurusan' => 'IPA',
                    'login_token' => str_pad((string) random_int(10000, 99999), 5, '0', STR_PAD_LEFT),
                ]
            );
        }
    }
}