<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Seed roles/permissions and demo users
        $this->call([
            RolePermissionSeeder::class,
        ]);

        // Use DemoDataSeeder when running on SQLite; otherwise import SQL dump
        $driver = config('database.default');
        if ($driver === 'sqlite') {
            $this->call([DemoDataSeeder::class]);
        } else {
            $this->call([SqlDumpSeeder::class]);
        }
    }
}
