<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;

class AssignSuperAdmin extends Seeder
{
    public function run(): void
    {
        $user = User::where('email', 'superadmin@gmail.com')->first();
        if (!$user) {
            $user = User::create([
                'name' => 'Super Admin',
                'email' => 'superadmin@gmail.com',
                'password' => bcrypt('password'),
            ]);
        }

        // Ensure role exists
        $role = Role::firstOrCreate([
            'name' => 'super_admin',
            'guard_name' => 'web',
        ]);

        $user->assignRole($role);
    }
}