<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('exam_sessions', function (Blueprint $table) {
            if (!Schema::hasColumn('exam_sessions', 'finish_requested_at')) {
                $table->timestamp('finish_requested_at')->nullable()->after('finished_at');
            }
            if (!Schema::hasColumn('exam_sessions', 'submissions_count')) {
                $table->unsignedInteger('submissions_count')->default(0)->after('finish_requested_at');
            }
        });
    }

    public function down(): void
    {
        Schema::table('exam_sessions', function (Blueprint $table) {
            if (Schema::hasColumn('exam_sessions', 'submissions_count')) {
                $table->dropColumn('submissions_count');
            }
            if (Schema::hasColumn('exam_sessions', 'finish_requested_at')) {
                $table->dropColumn('finish_requested_at');
            }
        });
    }
};