<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('questions', function (Blueprint $table) {
            if (!Schema::hasColumn('questions', 'subject_id')) {
                $table->foreignId('subject_id')->nullable()->after('image_path');
            }
        });

        $driver = Schema::getConnection()->getDriverName();
        if ($driver !== 'sqlite') {
            try {
                Schema::table('questions', function (Blueprint $table) {
                    // Tambahkan FK hanya bila belum ada; jika duplikat, abaikan.
                    $table->foreign('subject_id')->references('id')->on('subjects')->nullOnDelete();
                });
            } catch (\Throwable $e) {
                // Biarkan jika constraint sudah ada
            }
        }
    }

    public function down(): void
    {
        // Hapus FK lalu kolom
        try {
            Schema::table('questions', function (Blueprint $table) {
                $table->dropForeign(['subject_id']);
            });
        } catch (\Throwable $e) {
            // Constraint mungkin tidak ada; abaikan
        }

        Schema::table('questions', function (Blueprint $table) {
            if (Schema::hasColumn('questions', 'subject_id')) {
                $table->dropColumn('subject_id');
            }
        });
    }
};