<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void
    {
        $driver = Schema::getConnection()->getDriverName();
        // Ubah kolom key_answer agar bisa menyimpan teks (kunci essay)
        if (in_array($driver, ['mysql', 'mariadb'])) {
            DB::statement('ALTER TABLE questions MODIFY key_answer TEXT NOT NULL');
        } elseif ($driver === 'pgsql') {
            DB::statement('ALTER TABLE questions ALTER COLUMN key_answer TYPE TEXT');
            DB::statement('ALTER TABLE questions ALTER COLUMN key_answer SET NOT NULL');
        } else {
            // Untuk SQLite, enum biasanya sudah jadi TEXT, abaikan
        }
    }

    public function down(): void
    {
        $driver = Schema::getConnection()->getDriverName();
        // Kembalikan ke string pendek (tidak bisa enum A–E persis via portable migration)
        if (in_array($driver, ['mysql', 'mariadb'])) {
            DB::statement('ALTER TABLE questions MODIFY key_answer VARCHAR(10) NOT NULL');
        } elseif ($driver === 'pgsql') {
            DB::statement('ALTER TABLE questions ALTER COLUMN key_answer TYPE VARCHAR(10)');
            DB::statement('ALTER TABLE questions ALTER COLUMN key_answer SET NOT NULL');
        } else {
            // SQLite: biarkan tetap TEXT
        }
    }
};