<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('subjects', function (Blueprint $table) {
            if (!Schema::hasColumn('subjects', 'created_by')) {
                $table->foreignId('created_by')->nullable()->after('id_grade');
            }
        });

        $driver = Schema::getConnection()->getDriverName();
        if ($driver !== 'sqlite') {
            Schema::table('subjects', function (Blueprint $table) {
                // Relasi ke users.id dengan ON DELETE SET NULL agar aman bila user dihapus
                $table->foreign('created_by')->references('id')->on('users')->nullOnDelete();
            });
        }
    }

    public function down(): void
    {
        Schema::table('subjects', function (Blueprint $table) {
            try { $table->dropForeign(['created_by']); } catch (\Throwable $e) {}
            if (Schema::hasColumn('subjects', 'created_by')) {
                $table->dropColumn('created_by');
            }
        });
    }
};