<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('exam_participants', function (Blueprint $table) {
            if (!Schema::hasColumn('exam_participants', 'password')) {
                $table->string('password')->nullable()->after('jurusan');
            }
            if (!Schema::hasColumn('exam_participants', 'last_activity')) {
                $table->timestamp('last_activity')->nullable()->after('password');
            }
        });
    }

    public function down(): void
    {
        Schema::table('exam_participants', function (Blueprint $table) {
            if (Schema::hasColumn('exam_participants', 'last_activity')) {
                $table->dropColumn('last_activity');
            }
            if (Schema::hasColumn('exam_participants', 'password')) {
                $table->dropColumn('password');
            }
        });
    }
};