<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('exam_results', function (Blueprint $table) {
            $table->id();
            $table->foreignId('exam_session_id')->constrained('exam_sessions')->cascadeOnDelete();
            $table->unsignedBigInteger('exam_id');
            $table->unsignedBigInteger('subject_id');
            $table->unsignedBigInteger('participant_id');
            $table->string('participant_nisn')->index();
            $table->string('participant_nama');
            $table->string('subject_name');
            $table->unsignedInteger('correct_count')->default(0);
            $table->unsignedInteger('wrong_count')->default(0);
            $table->unsignedInteger('total_count')->default(0);
            $table->decimal('score', 6, 2)->default(0); // (benar/total)*100
            $table->json('answers')->nullable(); // map { question_id: 'A'|'B'|'C'|'D'|'E' }
            $table->json('correct_order_indexes')->nullable(); // [1-based indexes in canonical subject order]
            $table->json('wrong_order_indexes')->nullable(); // [1-based indexes in canonical subject order]
            $table->timestamps();

            $table->index(['exam_id', 'subject_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('exam_results');
    }
};