<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void
    {
        // Hapus foreign key lama (SET NULL) jika ada
        Schema::table('subjects', function (Blueprint $table) {
            try { $table->dropForeign(['id_school']); } catch (\Throwable $e) {}
            try { $table->dropForeign(['id_grade']); } catch (\Throwable $e) {}
        });

        // Jadikan kolom wajib (NOT NULL) hanya untuk MySQL/MariaDB
        $driver = Schema::getConnection()->getDriverName();
        if (in_array($driver, ['mysql', 'mariadb'])) {
            DB::statement('ALTER TABLE subjects MODIFY id_school BIGINT UNSIGNED NOT NULL');
            DB::statement('ALTER TABLE subjects MODIFY id_grade BIGINT UNSIGNED NOT NULL');
        }

        // Tambahkan foreign key baru dengan CASCADE ON DELETE
        if ($driver !== 'sqlite') {
            Schema::table('subjects', function (Blueprint $table) {
                $table->foreign('id_school')->references('id')->on('schools')->cascadeOnDelete();
                $table->foreign('id_grade')->references('id')->on('grades')->cascadeOnDelete();
            });
        }
    }

    public function down(): void
    {
        // Kembalikan ke nullable dan SET NULL
        Schema::table('subjects', function (Blueprint $table) {
            try { $table->dropForeign(['id_school']); } catch (\Throwable $e) {}
            try { $table->dropForeign(['id_grade']); } catch (\Throwable $e) {}
        });

        $driver = Schema::getConnection()->getDriverName();
        if (in_array($driver, ['mysql', 'mariadb'])) {
            DB::statement('ALTER TABLE subjects MODIFY id_school BIGINT UNSIGNED NULL');
            DB::statement('ALTER TABLE subjects MODIFY id_grade BIGINT UNSIGNED NULL');
        }

        if ($driver !== 'sqlite') {
            Schema::table('subjects', function (Blueprint $table) {
                $table->foreign('id_school')->references('id')->on('schools')->nullOnDelete();
                $table->foreign('id_grade')->references('id')->on('grades')->nullOnDelete();
            });
        }
    }
};