<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Tambahkan kolom bila belum ada
        Schema::table('subjects', function (Blueprint $table) {
            if (!Schema::hasColumn('subjects', 'id_school')) {
                $table->foreignId('id_school')->nullable()->after('code');
            }
            if (!Schema::hasColumn('subjects', 'id_grade')) {
                $table->foreignId('id_grade')->nullable()->after('id_school');
            }
        });

        // Pastikan kolom bersifat NULLable untuk ON DELETE SET NULL
        // Catatan: ALTER MODIFY hanya didukung di MySQL/MariaDB. Abaikan untuk SQLite.
        $driver = Schema::getConnection()->getDriverName();
        if (in_array($driver, ['mysql', 'mariadb'])) {
            if (Schema::hasColumn('subjects', 'id_school')) {
                \Illuminate\Support\Facades\DB::statement('ALTER TABLE subjects MODIFY id_school BIGINT UNSIGNED NULL');
            }
            if (Schema::hasColumn('subjects', 'id_grade')) {
                \Illuminate\Support\Facades\DB::statement('ALTER TABLE subjects MODIFY id_grade BIGINT UNSIGNED NULL');
            }
        }

        // Tambahkan constraint foreign key secara terpisah
        // Catatan: SQLite tidak mendukung penambahan constraint FK via ALTER TABLE dengan cara ini.
        // Untuk kompatibilitas dev menggunakan SQLite, lewati penambahan FK saat driver sqlite.
        if ($driver !== 'sqlite') {
            Schema::table('subjects', function (Blueprint $table) {
                // Hindari duplikasi constraint dengan pengecekan manual menggunakan SQL jika diperlukan
                $table->foreign('id_school')->references('id')->on('schools')->nullOnDelete();
                $table->foreign('id_grade')->references('id')->on('grades')->nullOnDelete();
            });
        }
    }

    public function down(): void
    {
        Schema::table('subjects', function (Blueprint $table) {
            $table->dropForeign(['id_school']);
            $table->dropForeign(['id_grade']);
            $table->dropColumn('id_school');
            $table->dropColumn('id_grade');
        });
    }
};