<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('exam_participants', function (Blueprint $table) {
            $table->id();
            $table->string('nisn')->unique();
            $table->string('nama');
            $table->unsignedBigInteger('id_kelas');
            $table->string('name_class');
            $table->string('jurusan')->nullable();
            $table->timestamps();

            $table->foreign('id_kelas')
                ->references('id')->on('classes')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('exam_participants');
    }
};