CREATE DATABASE IF NOT EXISTS `learning` DEFAULT CHARACTER SET utf8mb4 COLLATE=utf8mb4_unicode_ci;
USE `learning`;
SET FOREIGN_KEY_CHECKS=0;


CREATE TABLE IF NOT EXISTS `migrations` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `migration` VARCHAR(255) not null, `batch` INT not null) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO migrations VALUES(1,'0001_01_01_000000_create_users_table',1);
INSERT INTO migrations VALUES(2,'0001_01_01_000001_create_cache_table',1);
INSERT INTO migrations VALUES(3,'0001_01_01_000002_create_jobs_table',1);
INSERT INTO migrations VALUES(4,'2025_10_11_144332_add_last_activity_to_users_table',2);
INSERT INTO migrations VALUES(5,'2025_10_12_100939_create_permission_tables',2);
INSERT INTO migrations VALUES(6,'2025_10_12_230016_create_personal_access_tokens_table',2);
INSERT INTO migrations VALUES(7,'2025_10_13_000001_create_questions_table',2);
INSERT INTO migrations VALUES(8,'2025_10_13_000001_create_schools_table',2);
INSERT INTO migrations VALUES(9,'2025_10_13_000001_create_subjects_table',2);
INSERT INTO migrations VALUES(10,'2025_10_13_000002_add_subject_id_to_questions_table',2);
INSERT INTO migrations VALUES(11,'2025_10_13_000002_create_grades_table',2);
INSERT INTO migrations VALUES(12,'2025_10_13_000003_create_classes_table',2);
INSERT INTO migrations VALUES(13,'2025_10_13_000004_create_exam_participants_table',2);
INSERT INTO migrations VALUES(14,'2025_10_13_000005_add_name_to_classes_table',2);
INSERT INTO migrations VALUES(15,'2025_10_13_100000_add_password_to_exam_participants_table',2);
INSERT INTO migrations VALUES(16,'2025_10_13_110000_add_last_activity_to_exam_participants_table',2);
INSERT INTO migrations VALUES(17,'2025_10_13_120500_add_school_and_grade_to_subjects_table',3);
INSERT INTO migrations VALUES(18,'2025_10_13_121000_make_school_and_grade_required_in_subjects_table',4);
INSERT INTO migrations VALUES(19,'2025_10_13_122000_create_exams_table',4);
INSERT INTO migrations VALUES(20,'2025_10_13_123000_add_code_duration_schedule_to_exams_table',4);
INSERT INTO migrations VALUES(21,'2025_10_13_130000_create_exam_sessions_table',4);
INSERT INTO migrations VALUES(22,'2025_10_14_000003_create_exam_results_table',4);
INSERT INTO migrations VALUES(23,'2025_10_14_010500_fix_guard_names_in_roles_permissions',4);
INSERT INTO migrations VALUES(24,'2025_10_14_233600_add_profile_fields_to_users_table',5);
INSERT INTO migrations VALUES(25,'2025_10_14_120000_add_login_token_and_device_to_exam_participants_table',6);
INSERT INTO migrations VALUES(26,'2025_10_14_121000_add_draft_answers_to_exam_sessions_table',6);
INSERT INTO migrations VALUES(27,'2025_10_15_000001_add_password_and_last_activity_to_exam_participants_table',6);
INSERT INTO migrations VALUES(28,'2025_10_14_000001_add_media_columns_to_schools_table',7);
INSERT INTO migrations VALUES(29,'2025_10_15_010100_add_kepsek_to_schools_table',8);
INSERT INTO migrations VALUES(30,'2025_10_15_020500_add_fields_to_schools_table',9);
INSERT INTO migrations VALUES(31,'2025_10_15_030000_add_created_by_to_subjects_table',10);
CREATE TABLE IF NOT EXISTS `users` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `name` VARCHAR(255) not null, `email` VARCHAR(255) not null, `email_verified_at` DATETIME, `password` VARCHAR(255) not null, `remember_token` VARCHAR(255), `created_at` DATETIME, `updated_at` DATETIME, `last_activity` DATETIME, `nik` VARCHAR(255), `nuptk` VARCHAR(255), `terdaftar` VARCHAR(255), `jabatan` VARCHAR(255), `pegawai` VARCHAR(255), `status` VARCHAR(255), `aktivitas` VARCHAR(255)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO users VALUES(1,'Super Admin','superadmin@ujian.com',NULL,'$2y$12$VfGnmeuCzcGtgaG2iAojeeyZRn6VSV285i3GYBGtLZShwgvNp5u0C',NULL,'2025-10-14 23:34:22','2025-10-16 20:42:13','2025-10-16 20:42:13',NULL,NULL,NULL,NULL,NULL,'aktif',NULL);
INSERT INTO users VALUES(2,'Pegawai TU','pegawai@ujian.com',NULL,'$2y$12$m47brwlDNyelU/YdB8ZV5.xp84jMuqvXLEWFmmEJT7/Ap4WDdL92K',NULL,'2025-10-14 23:34:23','2025-10-15 15:06:59','2025-10-15 13:57:14',NULL,NULL,NULL,NULL,NULL,'aktif',NULL);
INSERT INTO users VALUES(3,'Guru Matematika','guru@ujian.com',NULL,'$2y$12$eSyG0zVUN3rcOvfuCIqrSeBC0c0bGFKjJE.3C77bOTXrDlzHt8/pS',NULL,'2025-10-14 23:34:23','2025-10-15 15:06:59','2025-10-15 14:08:42',NULL,NULL,NULL,NULL,NULL,'aktif',NULL);
INSERT INTO users VALUES(4,'Murid','murid@ujian.com',NULL,'$2y$12$n8JLpTFPR2cmyAVkPiuyX.1K8OY5bk9ZR4uFffTRTERGCUzQXJ3JC',NULL,'2025-10-14 23:34:23','2025-10-15 15:07:00',NULL,NULL,NULL,NULL,NULL,NULL,'aktif',NULL);
INSERT INTO users VALUES(5,'Guru PKN','pkn@gmail.com',NULL,'$2y$12$z9GGhDAJEoyvLqw/GmcaQeuyqcpBB.ID8yvoKxFxgX8Y0tdw6n3YO',NULL,'2025-10-15 14:10:06','2025-10-15 14:10:23','2025-10-15 14:10:23',NULL,NULL,NULL,NULL,NULL,'aktif',NULL);
CREATE TABLE IF NOT EXISTS `password_reset_tokens` (`email` VARCHAR(255) not null, `token` VARCHAR(255) not null, `created_at` DATETIME, PRIMARY KEY (`email`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `sessions` (`id` VARCHAR(255) not null, `user_id` INT, `ip_address` VARCHAR(255), `user_agent` TEXT, `payload` TEXT not null, `last_activity` INT not null, PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO sessions VALUES('u5gIAoMpOFziIX48sa2ftn181iHKwwBDfVhjCiie',NULL,'127.0.0.1','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36','YTozOntzOjY6Il90b2tlbiI7czo0MDoiYXdiVm5TZEhaMFUybXJBTzBZVUFXWXp3V3IzM1dhUGhHTFFvWm9SNCI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MjE6Imh0dHA6Ly8xMjcuMC4wLjE6ODAwMCI7fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=',1760114698);
CREATE TABLE IF NOT EXISTS `cache` (`key` VARCHAR(255) not null, `value` TEXT not null, `expiration` INT not null, PRIMARY KEY (`key`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO cache VALUES('fr-sqdf-cache-5dc3556dd6ff2daaaceb0f266f657915:timer','i:1760583815;',1760583815);
INSERT INTO cache VALUES('fr-sqdf-cache-5dc3556dd6ff2daaaceb0f266f657915','i:2;',1760583815);
INSERT INTO cache VALUES('fr-sqdf-cache-spatie.permission.cache','a:3:{s:5:"alias";a:4:{s:1:"a";s:2:"id";s:1:"b";s:4:"name";s:1:"c";s:10:"guard_name";s:1:"r";s:5:"roles";}s:11:"permissions";a:33:{i:0;a:4:{s:1:"a";i:1;s:1:"b";s:14:"view-dashboard";s:1:"c";s:3:"web";s:1:"r";a:4:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;}}i:1;a:4:{s:1:"a";i:2;s:1:"b";s:12:"manage-users";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:2;a:4:{s:1:"a";i:3;s:1:"b";s:11:"create-user";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:3;a:4:{s:1:"a";i:4;s:1:"b";s:9:"edit-user";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:4;a:4:{s:1:"a";i:5;s:1:"b";s:11:"delete-user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:5;a:4:{s:1:"a";i:6;s:1:"b";s:9:"view-user";s:1:"c";s:3:"web";s:1:"r";a:3:{i:0;i:1;i:1;i:2;i:2;i:3;}}i:6;a:4:{s:1:"a";i:7;s:1:"b";s:14:"reset-password";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:7;a:4:{s:1:"a";i:8;s:1:"b";s:12:"manage-roles";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:8;a:4:{s:1:"a";i:9;s:1:"b";s:18:"assign-permissions";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:9;a:4:{s:1:"a";i:10;s:1:"b";s:11:"create-exam";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:10;a:4:{s:1:"a";i:11;s:1:"b";s:9:"edit-exam";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:11;a:4:{s:1:"a";i:12;s:1:"b";s:11:"delete-exam";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:12;a:4:{s:1:"a";i:13;s:1:"b";s:9:"view-exam";s:1:"c";s:3:"web";s:1:"r";a:3:{i:0;i:1;i:1;i:2;i:2;i:3;}}i:13;a:4:{s:1:"a";i:14;s:1:"b";s:12:"manage-exams";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:14;a:4:{s:1:"a";i:15;s:1:"b";s:15:"create-question";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:15;a:4:{s:1:"a";i:16;s:1:"b";s:13:"edit-question";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:16;a:4:{s:1:"a";i:17;s:1:"b";s:15:"delete-question";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:17;a:4:{s:1:"a";i:18;s:1:"b";s:13:"view-question";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:18;a:4:{s:1:"a";i:19;s:1:"b";s:16:"manage-questions";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:19;a:4:{s:1:"a";i:20;s:1:"b";s:11:"input-score";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:20;a:4:{s:1:"a";i:21;s:1:"b";s:10:"edit-score";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:21;a:4:{s:1:"a";i:22;s:1:"b";s:10:"view-score";s:1:"c";s:3:"web";s:1:"r";a:3:{i:0;i:1;i:1;i:2;i:2;i:3;}}i:22;a:4:{s:1:"a";i:23;s:1:"b";s:13:"manage-scores";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:23;a:4:{s:1:"a";i:24;s:1:"b";s:13:"export-scores";s:1:"c";s:3:"web";s:1:"r";a:3:{i:0;i:1;i:1;i:2;i:2;i:3;}}i:24;a:4:{s:1:"a";i:25;s:1:"b";s:9:"take-exam";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:4;}}i:25;a:4:{s:1:"a";i:26;s:1:"b";s:11:"view-result";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:4;}}i:26;a:4:{s:1:"a";i:27;s:1:"b";s:12:"view-subject";s:1:"c";s:3:"web";s:1:"r";a:3:{i:0;i:1;i:1;i:2;i:2;i:3;}}i:27;a:4:{s:1:"a";i:28;s:1:"b";s:14:"create-subject";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:28;a:4:{s:1:"a";i:29;s:1:"b";s:12:"edit-subject";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:29;a:4:{s:1:"a";i:30;s:1:"b";s:14:"delete-subject";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}i:30;a:4:{s:1:"a";i:31;s:1:"b";s:15:"manage-subjects";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:31;a:4:{s:1:"a";i:32;s:1:"b";s:17:"view-all-subjects";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:32;a:4:{s:1:"a";i:33;s:1:"b";s:17:"view-own-subjects";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:3;}}}s:5:"roles";a:4:{i:0;a:3:{s:1:"a";i:1;s:1:"b";s:10:"superadmin";s:1:"c";s:3:"web";}i:1;a:3:{s:1:"a";i:2;s:1:"b";s:7:"pegawai";s:1:"c";s:3:"web";}i:2;a:3:{s:1:"a";i:3;s:1:"b";s:4:"guru";s:1:"c";s:3:"web";}i:3;a:3:{s:1:"a";i:4;s:1:"b";s:5:"murid";s:1:"c";s:3:"web";}}}',1760670180);
INSERT INTO cache VALUES('fr-sqdf-cache-707db6c5613b94753f68fa8c20449536:timer','i:1760611932;',1760611932);
INSERT INTO cache VALUES('fr-sqdf-cache-707db6c5613b94753f68fa8c20449536','i:1;',1760611932);
INSERT INTO cache VALUES('fr-sqdf-cache-006af56a6e96c4829ba04a6e6ebfc451:timer','i:1760624852;',1760624852);
INSERT INTO cache VALUES('fr-sqdf-cache-006af56a6e96c4829ba04a6e6ebfc451','i:1;',1760624852);
INSERT INTO cache VALUES('fr-sqdf-cache-fab7596a2ff819f281afa96b4c083b3c:timer','i:1760624873;',1760624873);
INSERT INTO cache VALUES('fr-sqdf-cache-fab7596a2ff819f281afa96b4c083b3c','i:1;',1760624873);
INSERT INTO cache VALUES('fr-sqdf-cache-3a9cf4f33db47326c5873f0aef27fc23:timer','i:1760624879;',1760624879);
INSERT INTO cache VALUES('fr-sqdf-cache-3a9cf4f33db47326c5873f0aef27fc23','i:1;',1760624879);
CREATE TABLE IF NOT EXISTS `cache_locks` (`key` VARCHAR(255) not null, `owner` VARCHAR(255) not null, `expiration` INT not null, PRIMARY KEY (`key`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `jobs` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `queue` VARCHAR(255) not null, `payload` TEXT not null, `attempts` INT not null, `reserved_at` INT, `available_at` INT not null, `created_at` INT not null) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO jobs VALUES(1,'autosave','{"uuid":"52f50c6b-b39a-4b59-9839-8fa12d80c79e","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:1;s:13:\"participantId\";i:7;s:7:\"answers\";a:1:{i:14;s:1:\"B\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760519527,"delay":null}',0,NULL,1760519527,1760519527);
INSERT INTO jobs VALUES(2,'autosave','{"uuid":"3de76da1-c83b-44bb-91d0-d84bd658d7f0","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:1;s:13:\"participantId\";i:7;s:7:\"answers\";a:1:{i:14;s:1:\"A\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760519531,"delay":null}',0,NULL,1760519531,1760519531);
INSERT INTO jobs VALUES(3,'autosave','{"uuid":"61de347b-cf35-4410-a918-5e0fab64dad6","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:2;s:13:\"participantId\";i:7;s:7:\"answers\";a:1:{i:10;s:1:\"A\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760520603,"delay":null}',0,NULL,1760520603,1760520603);
INSERT INTO jobs VALUES(4,'autosave','{"uuid":"51dac059-0ad1-48da-93bf-ad50b88d6536","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:2;s:13:\"participantId\";i:7;s:7:\"answers\";a:1:{i:9;s:1:\"D\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760520613,"delay":null}',0,NULL,1760520613,1760520613);
INSERT INTO jobs VALUES(5,'autosave','{"uuid":"ddaf1e98-4df5-48d7-99ec-700c7f87d05a","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:3;s:13:\"participantId\";i:7;s:7:\"answers\";a:1:{i:7;s:1:\"D\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760520786,"delay":null}',0,NULL,1760520786,1760520786);
INSERT INTO jobs VALUES(6,'autosave','{"uuid":"8bb5536b-33c6-48ad-8575-1b8957dcd284","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:3;s:13:\"participantId\";i:7;s:7:\"answers\";a:1:{i:7;s:1:\"A\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760522358,"delay":null}',0,NULL,1760522358,1760522358);
INSERT INTO jobs VALUES(7,'autosave','{"uuid":"a1ca175f-c163-4936-b6dd-9499760c1706","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:3;s:13:\"participantId\";i:7;s:7:\"answers\";a:1:{i:7;s:1:\"B\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760522363,"delay":null}',0,NULL,1760522363,1760522363);
INSERT INTO jobs VALUES(8,'autosave','{"uuid":"aaf35851-8875-4708-b286-de50173ec50f","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:1;s:13:\"participantId\";i:7;s:7:\"answers\";a:1:{i:7;s:1:\"A\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760522648,"delay":null}',0,NULL,1760522648,1760522648);
INSERT INTO jobs VALUES(9,'autosave','{"uuid":"3bc895c8-204a-47d8-b5d2-528d95e67dc0","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:1;s:13:\"participantId\";i:7;s:7:\"answers\";a:1:{i:7;s:1:\"B\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760522650,"delay":null}',0,NULL,1760522650,1760522650);
INSERT INTO jobs VALUES(10,'autosave','{"uuid":"87797d81-a1f1-466b-b57a-6f7c75a37ca6","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:1;s:13:\"participantId\";i:7;s:7:\"answers\";a:9:{i:1;s:1:\"B\";i:2;s:1:\"E\";i:4;s:1:\"A\";i:5;s:1:\"A\";i:6;s:1:\"A\";i:11;s:1:\"A\";i:12;s:1:\"A\";i:13;s:1:\"4\";i:14;s:10:\"Abi Hendri\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760522711,"delay":null}',0,NULL,1760522711,1760522711);
INSERT INTO jobs VALUES(11,'autosave','{"uuid":"3ebae637-c003-4161-996c-7ebc6960c0a9","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:4;s:13:\"participantId\";i:3;s:7:\"answers\";a:1:{i:5;s:1:\"A\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760525238,"delay":null}',0,NULL,1760525238,1760525238);
INSERT INTO jobs VALUES(12,'autosave','{"uuid":"530c8105-09bd-40fd-80c6-5c6b0c99449d","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:4;s:13:\"participantId\";i:3;s:7:\"answers\";a:1:{i:1;s:1:\"B\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760525242,"delay":null}',0,NULL,1760525242,1760525242);
INSERT INTO jobs VALUES(13,'autosave','{"uuid":"98991319-401e-4f83-b838-cd44cc5b7984","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:4;s:13:\"participantId\";i:3;s:7:\"answers\";a:1:{i:5;s:1:\"A\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760525516,"delay":null}',0,NULL,1760525516,1760525516);
INSERT INTO jobs VALUES(14,'autosave','{"uuid":"a38a0374-96e5-4951-8274-095872601044","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:4;s:13:\"participantId\";i:3;s:7:\"answers\";a:1:{i:1;s:1:\"C\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760525522,"delay":null}',0,NULL,1760525522,1760525522);
INSERT INTO jobs VALUES(15,'autosave','{"uuid":"d08e5795-d825-4106-ad43-39bfba200baf","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:4;s:13:\"participantId\";i:3;s:7:\"answers\";a:1:{i:5;s:1:\"A\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760526283,"delay":null}',0,NULL,1760526283,1760526283);
INSERT INTO jobs VALUES(16,'autosave','{"uuid":"f4dc149e-d93a-4e54-9714-89e8d5784ffd","displayName":"App\\Jobs\\SaveExamDraftAnswers","job":"Illuminate\\Queue\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"App\\Jobs\\SaveExamDraftAnswers","command":"O:29:\"App\\Jobs\\SaveExamDraftAnswers\":5:{s:9:\"sessionId\";i:4;s:13:\"participantId\";i:3;s:7:\"answers\";a:1:{i:1;s:1:\"B\";}s:4:\"meta\";a:2:{s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:117:\"Mozilla\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\/537.36 (KHTML, like Gecko) Chrome\/141.0.0.0 Safari\/537.36\";}s:5:\"queue\";s:8:\"autosave\";}"},"createdAt":1760526286,"delay":null}',0,NULL,1760526286,1760526286);
CREATE TABLE IF NOT EXISTS `job_batches` (`id` VARCHAR(255) not null, `name` VARCHAR(255) not null, `total_jobs` INT not null, `pending_jobs` INT not null, `failed_jobs` INT not null, `failed_job_ids` TEXT not null, `options` TEXT, `cancelled_at` INT, `created_at` INT not null, `finished_at` INT, PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `failed_jobs` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `uuid` VARCHAR(255) not null, `connection` TEXT not null, `queue` TEXT not null, `payload` TEXT not null, `exception` TEXT not null, `failed_at` DATETIME not null default CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `permissions` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `name` VARCHAR(255) not null, `guard_name` VARCHAR(255) not null, `created_at` DATETIME, `updated_at` DATETIME) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO permissions VALUES(1,'view-dashboard','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(2,'manage-users','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(3,'create-user','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(4,'edit-user','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(5,'delete-user','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(6,'view-user','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(7,'reset-password','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(8,'manage-roles','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(9,'assign-permissions','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(10,'create-exam','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(11,'edit-exam','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(12,'delete-exam','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(13,'view-exam','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(14,'manage-exams','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(15,'create-question','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(16,'edit-question','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(17,'delete-question','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(18,'view-question','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(19,'manage-questions','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(20,'input-score','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(21,'edit-score','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(22,'view-score','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(23,'manage-scores','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(24,'export-scores','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(25,'take-exam','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(26,'view-result','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO permissions VALUES(27,'view-subject','web','2025-10-15 14:04:22','2025-10-15 14:04:22');
INSERT INTO permissions VALUES(28,'create-subject','web','2025-10-15 14:04:22','2025-10-15 14:04:22');
INSERT INTO permissions VALUES(29,'edit-subject','web','2025-10-15 14:04:22','2025-10-15 14:04:22');
INSERT INTO permissions VALUES(30,'delete-subject','web','2025-10-15 14:04:22','2025-10-15 14:04:22');
INSERT INTO permissions VALUES(31,'manage-subjects','web','2025-10-15 14:04:22','2025-10-15 14:04:22');
INSERT INTO permissions VALUES(32,'view-all-subjects','web','2025-10-15 14:04:22','2025-10-15 14:04:22');
INSERT INTO permissions VALUES(33,'view-own-subjects','web','2025-10-15 14:04:22','2025-10-15 14:04:22');
CREATE TABLE IF NOT EXISTS `roles` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `name` VARCHAR(255) not null, `guard_name` VARCHAR(255) not null, `created_at` DATETIME, `updated_at` DATETIME) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO roles VALUES(1,'superadmin','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO roles VALUES(2,'pegawai','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO roles VALUES(3,'guru','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
INSERT INTO roles VALUES(4,'murid','web','2025-10-14 23:32:56','2025-10-14 23:32:56');
CREATE TABLE IF NOT EXISTS `model_has_permissions` (`permission_id` INT not null, `model_type` VARCHAR(255) not null, `model_id` INT not null, foreign key(`permission_id`) references `permissions`(`id`) on delete cascade, PRIMARY KEY (`permission_id`, `model_id`, `model_type`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `model_has_roles` (`role_id` INT not null, `model_type` VARCHAR(255) not null, `model_id` INT not null, foreign key(`role_id`) references `roles`(`id`) on delete cascade, PRIMARY KEY (`role_id`, `model_id`, `model_type`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO model_has_roles VALUES(3,'App\Models\User',5);
INSERT INTO model_has_roles VALUES(1,'App\Models\User',1);
INSERT INTO model_has_roles VALUES(2,'App\Models\User',2);
INSERT INTO model_has_roles VALUES(3,'App\Models\User',3);
INSERT INTO model_has_roles VALUES(4,'App\Models\User',4);
CREATE TABLE IF NOT EXISTS `role_has_permissions` (`permission_id` INT not null, `role_id` INT not null, foreign key(`permission_id`) references `permissions`(`id`) on delete cascade, foreign key(`role_id`) references `roles`(`id`) on delete cascade, PRIMARY KEY (`permission_id`, `role_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO role_has_permissions VALUES(1,1);
INSERT INTO role_has_permissions VALUES(2,1);
INSERT INTO role_has_permissions VALUES(3,1);
INSERT INTO role_has_permissions VALUES(4,1);
INSERT INTO role_has_permissions VALUES(5,1);
INSERT INTO role_has_permissions VALUES(6,1);
INSERT INTO role_has_permissions VALUES(7,1);
INSERT INTO role_has_permissions VALUES(8,1);
INSERT INTO role_has_permissions VALUES(9,1);
INSERT INTO role_has_permissions VALUES(10,1);
INSERT INTO role_has_permissions VALUES(11,1);
INSERT INTO role_has_permissions VALUES(12,1);
INSERT INTO role_has_permissions VALUES(13,1);
INSERT INTO role_has_permissions VALUES(14,1);
INSERT INTO role_has_permissions VALUES(15,1);
INSERT INTO role_has_permissions VALUES(16,1);
INSERT INTO role_has_permissions VALUES(17,1);
INSERT INTO role_has_permissions VALUES(18,1);
INSERT INTO role_has_permissions VALUES(19,1);
INSERT INTO role_has_permissions VALUES(20,1);
INSERT INTO role_has_permissions VALUES(21,1);
INSERT INTO role_has_permissions VALUES(22,1);
INSERT INTO role_has_permissions VALUES(23,1);
INSERT INTO role_has_permissions VALUES(24,1);
INSERT INTO role_has_permissions VALUES(25,1);
INSERT INTO role_has_permissions VALUES(26,1);
INSERT INTO role_has_permissions VALUES(27,1);
INSERT INTO role_has_permissions VALUES(28,1);
INSERT INTO role_has_permissions VALUES(29,1);
INSERT INTO role_has_permissions VALUES(30,1);
INSERT INTO role_has_permissions VALUES(31,1);
INSERT INTO role_has_permissions VALUES(32,1);
INSERT INTO role_has_permissions VALUES(33,1);
INSERT INTO role_has_permissions VALUES(1,2);
INSERT INTO role_has_permissions VALUES(2,2);
INSERT INTO role_has_permissions VALUES(3,2);
INSERT INTO role_has_permissions VALUES(4,2);
INSERT INTO role_has_permissions VALUES(6,2);
INSERT INTO role_has_permissions VALUES(7,2);
INSERT INTO role_has_permissions VALUES(13,2);
INSERT INTO role_has_permissions VALUES(22,2);
INSERT INTO role_has_permissions VALUES(24,2);
INSERT INTO role_has_permissions VALUES(27,2);
INSERT INTO role_has_permissions VALUES(32,2);
INSERT INTO role_has_permissions VALUES(1,3);
INSERT INTO role_has_permissions VALUES(6,3);
INSERT INTO role_has_permissions VALUES(10,3);
INSERT INTO role_has_permissions VALUES(11,3);
INSERT INTO role_has_permissions VALUES(12,3);
INSERT INTO role_has_permissions VALUES(13,3);
INSERT INTO role_has_permissions VALUES(14,3);
INSERT INTO role_has_permissions VALUES(15,3);
INSERT INTO role_has_permissions VALUES(16,3);
INSERT INTO role_has_permissions VALUES(17,3);
INSERT INTO role_has_permissions VALUES(18,3);
INSERT INTO role_has_permissions VALUES(19,3);
INSERT INTO role_has_permissions VALUES(20,3);
INSERT INTO role_has_permissions VALUES(21,3);
INSERT INTO role_has_permissions VALUES(22,3);
INSERT INTO role_has_permissions VALUES(23,3);
INSERT INTO role_has_permissions VALUES(24,3);
INSERT INTO role_has_permissions VALUES(27,3);
INSERT INTO role_has_permissions VALUES(33,3);
INSERT INTO role_has_permissions VALUES(28,3);
INSERT INTO role_has_permissions VALUES(29,3);
INSERT INTO role_has_permissions VALUES(30,3);
INSERT INTO role_has_permissions VALUES(1,4);
INSERT INTO role_has_permissions VALUES(25,4);
INSERT INTO role_has_permissions VALUES(26,4);
CREATE TABLE IF NOT EXISTS `role_user` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `user_id` INT not null, `role_id` INT not null, `created_at` DATETIME, `updated_at` DATETIME, foreign key(`user_id`) references `users`(`id`) on delete cascade, foreign key(`role_id`) references `roles`(`id`) on delete cascade) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `personal_access_tokens` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `tokenable_type` VARCHAR(255) not null, `tokenable_id` INT not null, `name` TEXT not null, `token` VARCHAR(255) not null, `abilities` TEXT, `last_used_at` DATETIME, `expires_at` DATETIME, `created_at` DATETIME, `updated_at` DATETIME) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO personal_access_tokens VALUES(1,'App\Models\User',1,'auth_token','d2624e1749ac20e6306e5b06032583dec1c7f283931fc8735c49451295de4eca','["*"]','2025-10-14 23:35:32',NULL,'2025-10-14 23:35:19','2025-10-14 23:35:32');
INSERT INTO personal_access_tokens VALUES(2,'App\Models\User',1,'auth_token','4202d402014c68f9caec70c2277ee87c8559bf70d852b4f9eb638ac97246d4be','["*"]','2025-10-14 23:43:17',NULL,'2025-10-14 23:38:51','2025-10-14 23:43:17');
INSERT INTO personal_access_tokens VALUES(3,'App\Models\User',1,'auth_token','b947a31e039521fd2b5dd9619a0bfcd9b26ead5245dd8bc31c7f23c827f0a4c9','["*"]','2025-10-14 23:45:19',NULL,'2025-10-14 23:44:57','2025-10-14 23:45:19');
INSERT INTO personal_access_tokens VALUES(4,'App\Models\User',1,'auth_token','e02006eb44aec768a16bbd4a8cfef0e4a89fb5b4546a18f515f96b1d747ddfb0','["*"]','2025-10-14 23:46:48',NULL,'2025-10-14 23:46:45','2025-10-14 23:46:48');
INSERT INTO personal_access_tokens VALUES(5,'App\Models\User',1,'auth_token','196511e39fe99c5d60b436f022286d5aa94b1db1766dd638e7e107ee00544d7a','["*"]','2025-10-14 23:55:18',NULL,'2025-10-14 23:47:10','2025-10-14 23:55:18');
INSERT INTO personal_access_tokens VALUES(6,'App\Models\User',1,'auth_token','d844ba446cd65903699508edd3ead74b46cd365021599cbf20b5668300fbc889','["*"]','2025-10-15 00:31:24',NULL,'2025-10-14 23:56:11','2025-10-15 00:31:24');
INSERT INTO personal_access_tokens VALUES(7,'App\Models\User',1,'auth_token','0f0d0784a8b481dd01ad9f8600a85da9a3700d1d6019c14624f560b7a7bb332d','["*"]','2025-10-15 00:59:18',NULL,'2025-10-15 00:32:14','2025-10-15 00:59:18');
INSERT INTO personal_access_tokens VALUES(8,'App\Models\User',1,'auth_token','3b4fbe714aed2a5e1ff78584cb61c9ed49087870225dede6915ff87ceac8314b','["*"]','2025-10-15 01:18:49',NULL,'2025-10-15 01:00:11','2025-10-15 01:18:49');
INSERT INTO personal_access_tokens VALUES(9,'App\Models\User',1,'auth_token','2580fc3b30cc8dd5a27e3309ae261f40010fa540010f7943c40590affa7648ed','["*"]','2025-10-15 10:57:00',NULL,'2025-10-15 01:23:10','2025-10-15 10:57:00');
INSERT INTO personal_access_tokens VALUES(10,'App\Models\User',1,'auth_token','d83b76da61d1275b0ef0df279aaf0c273a28dc431b2072546c25cbe91183cd7f','["*"]','2025-10-15 02:21:54',NULL,'2025-10-15 02:21:53','2025-10-15 02:21:54');
INSERT INTO personal_access_tokens VALUES(11,'App\Models\User',1,'auth_token','b537ea0d083503545467bb08cf208b6874a9b510e45af11cb7c9788930a22b92','["*"]','2025-10-15 14:03:26',NULL,'2025-10-15 02:22:33','2025-10-15 14:03:26');
INSERT INTO personal_access_tokens VALUES(12,'App\Models\User',1,'auth_token','7fcd04c44fa48bb7644cf3c680d24911296363556a36fc88e4dbfb415bb82051','["*"]','2025-10-15 10:25:42',NULL,'2025-10-15 09:11:42','2025-10-15 10:25:42');
INSERT INTO personal_access_tokens VALUES(13,'App\Models\User',1,'auth_token','5cce8fbf3d5c3d8f2cd1b303be43e5ae9a73d6da656924454a9be775a95485c3','["*"]','2025-10-15 13:33:46',NULL,'2025-10-15 13:11:46','2025-10-15 13:33:46');
INSERT INTO personal_access_tokens VALUES(14,'App\Models\User',1,'auth_token','f7f0f3160be37c54d8aaf6309b8ae82d4b59f268701e99c2318cab1718a8288b','["*"]','2025-10-15 13:53:45',NULL,'2025-10-15 13:33:58','2025-10-15 13:53:45');
INSERT INTO personal_access_tokens VALUES(15,'App\Models\User',3,'auth_token','c7d87f0f7141181e9200b7e6624b7f46227754be539ef6de5d14dbffd0f8407f','["*"]','2025-10-15 13:55:48',NULL,'2025-10-15 13:53:48','2025-10-15 13:55:48');
INSERT INTO personal_access_tokens VALUES(16,'App\Models\User',1,'auth_token','311ae3c14a73cbb86b3b6378c86cca36ffd3c516bbfe08984a81bd422210b000','["*"]','2025-10-15 13:56:10',NULL,'2025-10-15 13:55:51','2025-10-15 13:56:10');
INSERT INTO personal_access_tokens VALUES(17,'App\Models\User',2,'auth_token','f53388684d40b26a212f0f165802d7dc322508e4117d327cbfe11e6be95ac59b','["*"]','2025-10-15 13:57:43',NULL,'2025-10-15 13:56:14','2025-10-15 13:57:43');
INSERT INTO personal_access_tokens VALUES(18,'App\Models\User',1,'auth_token','bd75c29ef3a7f275dd19212a2fa4879edba63fa61266995cb61a5582fefd0529','["*"]','2025-10-16 09:46:43',NULL,'2025-10-15 13:57:47','2025-10-16 09:46:43');
INSERT INTO personal_access_tokens VALUES(19,'App\Models\User',3,'auth_token','4f6dddc6f212f4c3d401cd3997c81ec859d91f3323f9658aca1bdd644fdfecaa','["*"]','2025-10-15 14:03:43',NULL,'2025-10-15 14:03:32','2025-10-15 14:03:43');
INSERT INTO personal_access_tokens VALUES(20,'App\Models\User',1,'auth_token','326132fe6b46549c8e535d355a5964b954e47d64869e565142203e043344fc3f','["*"]','2025-10-15 14:08:29',NULL,'2025-10-15 14:03:59','2025-10-15 14:08:29');
INSERT INTO personal_access_tokens VALUES(21,'App\Models\User',3,'auth_token','2e62ba92ca11b818db9723ea520b58d7d6d8337363adf4772e1d83e15119d977','["*"]','2025-10-15 14:09:35',NULL,'2025-10-15 14:08:42','2025-10-15 14:09:35');
INSERT INTO personal_access_tokens VALUES(22,'App\Models\User',1,'auth_token','34b752f2afd7b3bdc7cd68efb321db023a85fa670535f3ed73ef3cd839164dcb','["*"]','2025-10-15 14:10:06',NULL,'2025-10-15 14:09:41','2025-10-15 14:10:06');
INSERT INTO personal_access_tokens VALUES(23,'App\Models\User',5,'auth_token','999bd43eb557f3c1ec0ec9c9a2b93b28a607e6c92e396acce0b69e8f05ab7ad8','["*"]','2025-10-15 14:10:47',NULL,'2025-10-15 14:10:23','2025-10-15 14:10:47');
INSERT INTO personal_access_tokens VALUES(24,'App\Models\User',1,'auth_token','0182b8f0f870cbcbf91d7535b4ddce8904ac5782cde65a80deed0858d24c2101','["*"]','2025-10-15 14:47:45',NULL,'2025-10-15 14:10:57','2025-10-15 14:47:45');
INSERT INTO personal_access_tokens VALUES(25,'App\Models\User',1,'auth_token','3ce2fa46c2d81cdb382de357a71a49f713ef0b0268f4753d7f3c9e3bdcbb09f5','["*"]',NULL,NULL,'2025-10-15 15:08:02','2025-10-15 15:08:02');
INSERT INTO personal_access_tokens VALUES(26,'App\Models\User',1,'auth_token','101ebcd8e4750b377516108c56fea0c5852c71f0c3bcd03a57f6e22aec9adcfd','["*"]','2025-10-15 15:55:40',NULL,'2025-10-15 15:16:59','2025-10-15 15:55:40');
INSERT INTO personal_access_tokens VALUES(27,'App\Models\User',1,'auth_token','022fbb6b9af6ad1078eac2f479505da901a1b0aa465ff46399a22457bc112505','["*"]','2025-10-15 18:21:16',NULL,'2025-10-15 15:56:43','2025-10-15 18:21:16');
INSERT INTO personal_access_tokens VALUES(34,'App\Models\User',1,'auth_token','9fc9408e0ee23ed51577be46a4ece2e937197b2591b2cb0b99c9485cc6df6e0a','["*"]','2025-10-16 16:40:51',NULL,'2025-10-16 10:03:00','2025-10-16 16:40:51');
INSERT INTO personal_access_tokens VALUES(35,'App\Models\User',1,'auth_token','8e9e2608cffa961bf9f7fe5e58276633a4abae993631f609fe86f890e43046d0','["*"]','2025-10-16 20:42:14',NULL,'2025-10-16 17:51:12','2025-10-16 20:42:14');
CREATE TABLE IF NOT EXISTS `schools` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `nama` VARCHAR(255) not null, `alamat` VARCHAR(255), `created_at` DATETIME, `updated_at` DATETIME, `logo_path` VARCHAR(255), `signature_path` VARCHAR(255), `stamp_path` VARCHAR(255), `kepsek` VARCHAR(255), `kode` VARCHAR(255), `kota` VARCHAR(255), `provinsi` VARCHAR(255), `no` VARCHAR(255), `status` VARCHAR(255) not null default 'Aktif', `note` TEXT) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO schools VALUES(1,'SMP Q BANDAR LAMPUNG','BANDAR LAMPUNG','2025-10-15 00:32:29','2025-10-15 00:33:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Aktif',NULL);
INSERT INTO schools VALUES(2,'SMP Q LAMPUNG SELATAN','LAMPUNG SELATAN','2025-10-15 00:32:38','2025-10-15 00:34:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Aktif',NULL);
INSERT INTO schools VALUES(3,'SMA QURAN DARUL FATTAH','Jl. Kopi No.23 A, Gedong Meneng, Kec. Rajabasa, Kota Bandar Lampung, Lampung 35141','2025-10-15 00:33:01','2025-10-15 12:42:07','schools/3/logo.png','schools/3/signature.png',NULL,'Fatkhurrahman, Lc,.M.Pd',NULL,NULL,NULL,NULL,'Aktif',NULL);
INSERT INTO schools VALUES(4,'Sekolah Uji 1760469713','Jalan Token','2025-10-15 02:21:53','2025-10-15 02:21:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Aktif',NULL);
CREATE TABLE IF NOT EXISTS `questions` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `TEXT` TEXT not null, `option_a` TEXT not null, `option_b` TEXT not null, `option_c` TEXT not null, `option_d` TEXT not null, `option_e` TEXT not null, `key_answer` VARCHAR(255) not null, `image_path` VARCHAR(255), `created_by` INT, `created_at` DATETIME, `updated_at` DATETIME, `subject_id` INT, foreign key(`subject_id`) references `subjects`(`id`) on delete set null) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO questions VALUES(1,'1+1','1','2','3','4','5','B',NULL,1,'2025-10-15 00:53:26','2025-10-15 00:53:26',2);
INSERT INTO questions VALUES(2,'5 X 5 =','20','21','22','24','25','E',NULL,1,'2025-10-15 00:53:55','2025-10-15 00:53:55',2);
INSERT INTO questions VALUES(4,replace(replace('![img](http://127.0.0.1:8001/storage/questions/8955bc8b-c70a-454c-bf83-efd784cf33b2.png) \r\nLogo diatas adalah ?','\r',char(13)),'\n',char(10)),'SQ','SD','SMP','SMA','SS','A',NULL,1,'2025-10-15 01:01:19','2025-10-15 01:01:19',2);
INSERT INTO questions VALUES(5,replace(replace('![img](http://127.0.0.1:8001/storage/questions/a21bed27-8ffe-42d2-ab5a-20bb36d0efe4.jpg) \r\nGambar diatas adalah ?','\r',char(13)),'\n',char(10)),'![img](http://127.0.0.1:8001/storage/questions/c7f6968c-bcd0-4b21-bc66-b1b31921d5bd.jpg)','![img](http://127.0.0.1:8001/storage/questions/32ad4f7c-b4b2-4ca2-a8d4-1085fe3d6531.jpeg)','![img](http://127.0.0.1:8001/storage/questions/733c762e-56b4-492f-a6b0-8ac5a18e6f52.png)','![img](http://127.0.0.1:8001/storage/questions/82decbc3-ef85-4542-afb2-0cfa81a1e2f6.png)','![img](http://127.0.0.1:8001/storage/questions/a61abb2c-afd7-468f-aa2a-0925146ae4a7.png)','A',NULL,1,'2025-10-15 01:28:55','2025-10-15 01:28:55',2);
INSERT INTO questions VALUES(6,'![img](http://127.0.0.1:8001/storage/questions/2250ddf7-5644-4234-a64a-f8e5e5c6dea9.jpg)','![img](http://127.0.0.1:8001/storage/questions/ae75f05a-7c55-4bf2-8733-2ccd5e5eb778.jpg)','sdwa','![img](http://127.0.0.1:8001/storage/questions/dc3fe360-bc18-45a3-b1d2-cd758a043029.png)','![img](http://127.0.0.1:8001/storage/questions/044c1a34-e49b-4552-8193-a398d51dfe8f.png)','','B',NULL,1,'2025-10-15 01:32:12','2025-10-15 01:32:12',2);
INSERT INTO questions VALUES(7,replace(replace('gambar dibawah  adalah ?\r\n ![img](http://127.0.0.1:8001/storage/questions/mtk-kelas-10/473f6e23-7161-402b-beff-472fd153801f.jpg)','\r',char(13)),'\n',char(10)),'laptop','server','sdw','ffff','vvvv','B',NULL,1,'2025-10-15 01:41:12','2025-10-15 01:41:12',2);
INSERT INTO questions VALUES(8,'pancasila ada','1','2','3','4','5','E',NULL,1,'2025-10-15 01:42:28','2025-10-15 01:42:28',1);
INSERT INTO questions VALUES(9,replace(replace('\begin{bmatrix}1 & 2 \\ 3 & d\end{bmatrix}\r\nhasilnya adalah ?','\r',char(13)),'\n',char(10)),'\begin{bmatrix}ad & s \\\end{bmatrix}','\sqrt{ 22}','\frac{1 }{ 1}','1\left(2  \right) x\theta -8°C','\sqrt{1}_1^1','E',NULL,1,'2025-10-15 01:47:04','2025-10-15 01:47:04',1);
INSERT INTO questions VALUES(10,'!بشأن أمي وتورطها في المشروع الع','بشأن أم المش','ترجمة الأفلام','روع العام','رطها ف','ي وتوي','C',NULL,1,'2025-10-15 01:52:43','2025-10-15 01:52:43',1);
INSERT INTO questions VALUES(11,'soal gamabar  ![img](http://127.0.0.1:8000/storage/questions/mtk-kelas-10/521eaafa-52d8-42be-8af7-4a7a0524ccc0.png)','1','2','3','4','5','C',NULL,1,'2025-10-15 15:36:51','2025-10-15 15:36:51',2);
INSERT INTO questions VALUES(12,'soal swal alert testing','[b]asdawda[/b]','adawda','sdwadaw','dwadaw','adwada','B',NULL,1,'2025-10-15 15:43:12','2025-10-15 15:43:12',2);
INSERT INTO questions VALUES(13,'pancailsa aline ke','4','','','','','A',NULL,1,'2025-10-15 15:51:09','2025-10-15 15:51:09',2);
INSERT INTO questions VALUES(14,'siapa nama guru ppkn ? secara lengkap !','Hendri Syaiful Nugraha, S.H. Gr','','','','','A',NULL,1,'2025-10-15 15:57:37','2025-10-15 15:57:37',2);
INSERT INTO questions VALUES(16,'apa','1','','','','','A',NULL,1,'2025-10-15 18:31:06','2025-10-15 18:31:06',4);
CREATE TABLE IF NOT EXISTS `grades` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `id_school` INT not null, `grade` INT not null, `created_at` DATETIME, `updated_at` DATETIME, foreign key(`id_school`) references `schools`(`id`) on delete cascade) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO grades VALUES(1,1,7,'2025-10-15 00:39:56','2025-10-15 00:39:56');
INSERT INTO grades VALUES(2,1,8,'2025-10-15 00:40:04','2025-10-15 00:40:04');
INSERT INTO grades VALUES(3,1,9,'2025-10-15 00:40:10','2025-10-15 00:40:10');
INSERT INTO grades VALUES(4,2,7,'2025-10-15 00:40:23','2025-10-15 00:40:23');
INSERT INTO grades VALUES(5,2,8,'2025-10-15 00:40:29','2025-10-15 00:40:29');
INSERT INTO grades VALUES(6,2,9,'2025-10-15 00:40:34','2025-10-15 00:40:34');
INSERT INTO grades VALUES(7,3,10,'2025-10-15 00:40:40','2025-10-15 00:40:40');
INSERT INTO grades VALUES(8,3,11,'2025-10-15 00:40:44','2025-10-15 00:40:44');
INSERT INTO grades VALUES(9,3,12,'2025-10-15 00:40:50','2025-10-15 00:40:50');
INSERT INTO grades VALUES(10,4,10,'2025-10-15 02:21:53','2025-10-15 02:21:53');
CREATE TABLE IF NOT EXISTS `classes` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `id_school` INT not null, `id_grade` INT not null, `created_at` DATETIME, `updated_at` DATETIME, `name` VARCHAR(255), foreign key(`id_school`) references `schools`(`id`) on delete cascade, foreign key(`id_grade`) references `grades`(`id`) on delete cascade) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO classes VALUES(1,3,7,'2025-10-15 00:50:15','2025-10-15 00:50:15','10A');
INSERT INTO classes VALUES(2,3,7,'2025-10-15 00:50:30','2025-10-15 00:50:30','10B');
INSERT INTO classes VALUES(3,3,7,'2025-10-15 00:50:39','2025-10-15 00:50:39','10C');
INSERT INTO classes VALUES(4,3,7,'2025-10-15 00:50:47','2025-10-15 00:50:47','10D');
INSERT INTO classes VALUES(5,3,7,'2025-10-15 00:50:56','2025-10-15 00:50:56','10E');
INSERT INTO classes VALUES(6,3,7,'2025-10-15 00:51:05','2025-10-15 00:51:05','10F');
INSERT INTO classes VALUES(7,4,10,'2025-10-15 02:21:53','2025-10-15 02:21:53','Kelas 10A');
CREATE TABLE IF NOT EXISTS `exam_participants` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `nisn` VARCHAR(255) not null, `nama` VARCHAR(255) not null, `id_kelas` INT not null, `name_class` VARCHAR(255) not null, `jurusan` VARCHAR(255), `created_at` DATETIME, `updated_at` DATETIME, `password` VARCHAR(255), `last_activity` DATETIME, `login_token` VARCHAR(255), `bound_device_hash` VARCHAR(255), `device_bound_at` DATETIME, foreign key(`id_kelas`) references `classes`(`id`) on delete cascade) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO exam_participants VALUES(1,'111','ANISA',1,'10A','IPA','2025-10-15 00:51:38','2025-10-16 21:26:43','$2y$12$4B22JmHs6YERJXy7YolEdudwoho/iimwOOU4JhE78keKQIMvD1lbO',NULL,'35196','$2y$12$hmRUFJ7VSsCDmMm6UzJEDejOOaAfOD7W1PqIr0VFphmsD44e7EUTe','2025-10-16 21:26:33');
INSERT INTO exam_participants VALUES(2,'222','BONI',2,'10B','IPS','2025-10-15 00:52:08','2025-10-15 16:00:13','$2y$12$4B22JmHs6YERJXy7YolEdudwoho/iimwOOU4JhE78keKQIMvD1lbO',NULL,'83504',NULL,NULL);
INSERT INTO exam_participants VALUES(3,'333','thre',3,'10C','BINDO','2025-10-15 02:06:46','2025-10-16 21:27:02','$2y$12$4B22JmHs6YERJXy7YolEdudwoho/iimwOOU4JhE78keKQIMvD1lbO',NULL,'75506','$2y$12$Emsl5xbniQqV5L2DQMWPjOfm9IzXJOf1NRO0gg.rBNRQiR9etQsZ6','2025-10-15 17:47:10');
INSERT INTO exam_participants VALUES(4,'1760469714','Peserta Satu',7,'Kelas 10A',NULL,'2025-10-15 02:21:53','2025-10-15 16:00:13','$2y$12$4B22JmHs6YERJXy7YolEdudwoho/iimwOOU4JhE78keKQIMvD1lbO',NULL,'10000',NULL,NULL);
INSERT INTO exam_participants VALUES(5,'1760469715','Peserta Dua',7,'Kelas 10A',NULL,'2025-10-15 02:21:54','2025-10-15 16:00:13','$2y$12$4B22JmHs6YERJXy7YolEdudwoho/iimwOOU4JhE78keKQIMvD1lbO',NULL,'63880',NULL,NULL);
INSERT INTO exam_participants VALUES(6,'123456','Peserta 3',7,'Kelas 10A','-','2025-10-15 11:17:57','2025-10-15 16:00:13','$2y$12$4B22JmHs6YERJXy7YolEdudwoho/iimwOOU4JhE78keKQIMvD1lbO',NULL,'56129',NULL,NULL);
INSERT INTO exam_participants VALUES(7,'567890','PESERTA 4',7,'Kelas 10A','-','2025-10-15 11:18:22','2025-10-15 17:46:51','$2y$12$4B22JmHs6YERJXy7YolEdudwoho/iimwOOU4JhE78keKQIMvD1lbO',NULL,'42771','$2y$12$1d.s19SfFYfjkfjIcWcIv.9KeCDQPIaakV5ZBBFO3eXQyAj5MNo66','2025-10-15 16:00:59');
CREATE TABLE IF NOT EXISTS `subjects` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `name` VARCHAR(255) not null, `code` VARCHAR(255), `description` TEXT, `created_at` DATETIME, `updated_at` DATETIME, `id_school` INT, `id_grade` INT, `created_by` INT) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO subjects VALUES(1,'PPKN KELAS 10','PPKN',NULL,'2025-10-15 00:52:34','2025-10-15 00:52:34',3,7,NULL);
INSERT INTO subjects VALUES(2,'MTK KELAS 10','MATEMATIKA',NULL,'2025-10-15 00:52:59','2025-10-15 00:52:59',3,7,NULL);
INSERT INTO subjects VALUES(3,'tes mapel guru mtk','mtk','-','2025-10-15 14:09:08','2025-10-15 14:09:08',2,4,3);
INSERT INTO subjects VALUES(4,'TES MAPEL PKN','PKN 9','-','2025-10-15 14:10:47','2025-10-15 14:10:47',1,3,5);
CREATE TABLE IF NOT EXISTS `exams` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `name` VARCHAR(255) not null, `description` TEXT, `id_subject` INT not null, `created_at` DATETIME, `updated_at` DATETIME, `code` VARCHAR(255) not null, `duration_minutes` INT not null, `scheduled_at` DATETIME not null, foreign key(`id_subject`) references `subjects`(`id`) on delete cascade) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO exams VALUES(1,'PPKN',NULL,1,'2025-10-15 01:53:19','2025-10-15 17:03:48','XFOEM3',15,'2025-10-15 17:01:00');
INSERT INTO exams VALUES(2,'MTK KELAS 10',NULL,2,'2025-10-15 01:53:52','2025-10-15 17:03:32','MEBUVK',15,'2025-10-15 17:00:00');
INSERT INTO exams VALUES(3,'ujian lewat','-',2,'2025-10-15 16:01:39','2025-10-15 17:03:24','YCHIJL',90,'2025-10-15 17:03:00');
CREATE TABLE IF NOT EXISTS `exam_sessions` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `exam_id` INT not null, `exam_participant_id` INT not null, `question_order` TEXT not null, `started_at` DATETIME, `finished_at` DATETIME, `created_at` DATETIME, `updated_at` DATETIME, `draft_answers` TEXT, foreign key(`exam_id`) references `exams`(`id`) on delete cascade, foreign key(`exam_participant_id`) references `exam_participants`(`id`) on delete cascade) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO exam_sessions VALUES(1,2,7,'[14,7,2,6,11,13,4,1,5,12]','2025-10-15 16:12:01','2025-10-15 17:05:13','2025-10-15 16:12:01','2025-10-15 17:05:13',NULL);
INSERT INTO exam_sessions VALUES(2,1,7,'[10,8,9]','2025-10-15 16:30:00',NULL,'2025-10-15 16:30:00','2025-10-15 16:30:00',NULL);
INSERT INTO exam_sessions VALUES(3,3,7,'[7,13,2,12,6,4,14,1,11,5]','2025-10-15 16:33:01',NULL,'2025-10-15 16:33:01','2025-10-15 16:33:01',NULL);
INSERT INTO exam_sessions VALUES(4,3,3,'[5,1,14,11,4,13,6,2,7,12]','2025-10-15 17:47:15','2025-10-15 18:05:47','2025-10-15 17:47:15','2025-10-15 18:05:47',NULL);
CREATE TABLE IF NOT EXISTS `exam_results` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, `exam_session_id` INT not null, `exam_id` INT not null, `subject_id` INT not null, `participant_id` INT not null, `participant_nisn` VARCHAR(255) not null, `participant_nama` VARCHAR(255) not null, `subject_name` VARCHAR(255) not null, `correct_count` INT not null default '0', `wrong_count` INT not null default '0', `total_count` INT not null default '0', `score` DECIMAL(10,0) not null default '0', `answers` TEXT, `correct_order_indexes` TEXT, `wrong_order_indexes` TEXT, `created_at` DATETIME, `updated_at` DATETIME, foreign key(`exam_session_id`) references `exam_sessions`(`id`) on delete cascade) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO exam_results VALUES(1,1,2,2,7,'567890','PESERTA 4','MTK KELAS 10',5,3,8,62.5,'["B","E","A","A","A","B","A","A","4","Abi Hendri"]','[1,2,3,4,6]','[5,7,8]','2025-10-15 17:05:13','2025-10-15 17:05:13');
INSERT INTO exam_results VALUES(2,4,3,2,3,'333','thre','MTK KELAS 10',5,3,8,62.5,'["B","E","A","A","A","B","A","A","4","hendri"]','[1,2,3,4,6]','[5,7,8]','2025-10-15 18:05:47','2025-10-15 18:05:47');
CREATE UNIQUE INDEX `users_email_unique` on `users` (`email`);
CREATE INDEX `sessions_user_id_index` on `sessions` (`user_id`);
CREATE INDEX `sessions_last_activity_index` on `sessions` (`last_activity`);
CREATE INDEX `jobs_queue_index` on `jobs` (`queue`);
CREATE UNIQUE INDEX `failed_jobs_uuid_unique` on `failed_jobs` (`uuid`);
CREATE UNIQUE INDEX `permissions_name_guard_name_unique` on `permissions` (`name`, `guard_name`);
CREATE UNIQUE INDEX `roles_name_guard_name_unique` on `roles` (`name`, `guard_name`);
CREATE INDEX `model_has_permissions_model_id_model_type_index` on `model_has_permissions` (`model_id`, `model_type`);
CREATE INDEX `model_has_roles_model_id_model_type_index` on `model_has_roles` (`model_id`, `model_type`);
CREATE INDEX `personal_access_tokens_tokenable_type_tokenable_id_index` on `personal_access_tokens` (`tokenable_type`, `tokenable_id`);
CREATE UNIQUE INDEX `personal_access_tokens_token_unique` on `personal_access_tokens` (`token`);
CREATE INDEX `personal_access_tokens_expires_at_index` on `personal_access_tokens` (`expires_at`);
CREATE UNIQUE INDEX `exam_participants_nisn_unique` on `exam_participants` (`nisn`);
CREATE UNIQUE INDEX `exams_code_unique` on `exams` (`code`);
CREATE UNIQUE INDEX `exam_sessions_exam_id_exam_participant_id_unique` on `exam_sessions` (`exam_id`, `exam_participant_id`);
CREATE INDEX `exam_results_exam_id_subject_id_index` on `exam_results` (`exam_id`, `subject_id`);
CREATE INDEX `exam_results_participant_nisn_index` on `exam_results` (`participant_nisn`);
CREATE UNIQUE INDEX `exam_participants_login_token_unique` on `exam_participants` (`login_token`);

SET FOREIGN_KEY_CHECKS=1;
