<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Support\Facades\Route;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
        api: __DIR__.'/../routes/api.php',  // <--- tambahkan ini
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->web(append: [
            //
        ]);

        // API uses token-based auth via Authorization: Bearer; do not enforce stateful SPA cookies
        // Removing Sanctum's stateful middleware here prevents CSRF/419 for /api/* endpoints
        $middleware->api(prepend: [
            // (intentionally empty)
        ]);

        $middleware->alias([
            'role' => \Spatie\Permission\Middleware\RoleMiddleware::class,
            'permission' => \Spatie\Permission\Middleware\PermissionMiddleware::class,
            'role_or_permission' => \Spatie\Permission\Middleware\RoleOrPermissionMiddleware::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
