<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Http\Request;

class RouteServiceProvider extends ServiceProvider
{
    protected $namespace = 'App\\Http\\Controllers';

    public function boot(): void
    {
        parent::boot();

        // Rate limiting untuk API umum dan endpoint login
        RateLimiter::for('api', function (Request $request) {
            $max = (int) env('API_RATE_LIMIT', 60);
            return Limit::perMinute($max)->by(optional($request->user())->id ?: $request->ip());
        });

        RateLimiter::for('login', function (Request $request) {
            $max = (int) env('LOGIN_RATE_LIMIT', 5);
            // Gunakan email/nisn bila ada; fallback ke token untuk login-token; terakhir guest
            $identifier = strtolower((string) (
                $request->input('email') ??
                $request->input('nisn') ??
                $request->input('token') ??
                'guest'
            ));
            return Limit::perMinute($max)->by($identifier.':'.$request->ip());
        });
    }

    public function map(): void
    {
        $this->mapWebRoutes();
        $this->mapApiRoutes();
    }

    protected function mapWebRoutes(): void
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/web.php'));
    }

    protected function mapApiRoutes(): void
    {
        Route::prefix('api')
            ->middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/api.php'));
    }
}
