<?php
namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    // Paksa Spatie Permission menggunakan guard 'web' untuk User
    protected $guard_name = 'web';

    protected $fillable = [
        'nik','nuptk','name','terdaftar','jabatan','pegawai','status','email','password','last_activity'
    ];

    protected $hidden = ['password','remember_token'];

    // convenience
    public function isOnline()
    {
        if (!$this->last_activity) return false;
        return now()->diffInMinutes($this->last_activity) < 5;
    }
    
    /**
     * Cek apakah user memiliki permission tertentu
     * 
     * @param string|array $permissions
     * @return bool
     */
    public function hasPermission($permissions)
    {
        if (is_string($permissions)) {
            return $this->hasPermissionTo($permissions);
        }
        
        foreach ($permissions as $permission) {
            if ($this->hasPermissionTo($permission)) {
                return true;
            }
        }
        
        return false;
    }
    
    /**
     * Cek apakah user memiliki role tertentu
     * 
     * @param string|array $roles
     * @return bool
     */
    public function hasUserRole($roles)
    {
        if (is_string($roles)) {
            return $this->hasRole($roles);
        }
        
        return $this->hasAnyRole($roles);
    }
}
