<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class School extends Model
{
    use HasFactory;

    protected $fillable = [
        'nama', 'alamat', 'kepsek',
        'kode', 'kota', 'provinsi', 'no', 'status', 'note',
        'logo_path', 'signature_path', 'stamp_path'
    ];

    public function grades()
    {
        return $this->hasMany(Grade::class, 'id_school');
    }

    public function classes()
    {
        return $this->hasMany(SchoolClass::class, 'id_school');
    }
}