<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Grade extends Model
{
    use HasFactory;

    protected $fillable = ['grade', 'id_school'];

    public function school()
    {
        return $this->belongsTo(School::class, 'id_school');
    }

    public function classes()
    {
        return $this->hasMany(SchoolClass::class, 'id_grade');
    }
}