<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExamSession extends Model
{
    use HasFactory;

    protected $fillable = ['exam_id', 'exam_participant_id', 'question_order', 'started_at', 'finished_at'];

    protected $casts = [
        'question_order' => 'array',
        'draft_answers' => 'array',
        'started_at' => 'datetime',
        'finished_at' => 'datetime',
    ];

    public function exam()
    {
        return $this->belongsTo(Exam::class);
    }

    public function participant()
    {
        return $this->belongsTo(ExamParticipant::class, 'exam_participant_id');
    }

    public function result()
    {
        return $this->hasOne(ExamResult::class, 'exam_session_id');
    }
}