<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExamResult extends Model
{
    use HasFactory;

    protected $fillable = [
        'exam_session_id', 'exam_id', 'subject_id', 'participant_id', 'participant_nisn', 'participant_nama', 'subject_name',
        'correct_count', 'wrong_count', 'essay_correct_count', 'essay_wrong_count', 'total_count', 'score', 'answers', 'essay_details', 'correct_order_indexes', 'wrong_order_indexes',
        'correct_orders_essays', 'wrong_orders_essay'
    ];

    protected $casts = [
        'answers' => 'array',
        'essay_details' => 'array',
        'correct_order_indexes' => 'array',
        'wrong_order_indexes' => 'array',
        'correct_orders_essays' => 'array',
        'wrong_orders_essay' => 'array',
    ];

    public function session()
    {
        return $this->belongsTo(ExamSession::class, 'exam_session_id');
    }
}