<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class NoCacheHeaders
{
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        // Remove validators to avoid conditional requests (ETag / Last-Modified)
        if (method_exists($response->headers, 'remove')) {
            $response->headers->remove('ETag');
            $response->headers->remove('Last-Modified');
        } else {
            $response->headers->set('ETag', null);
            $response->headers->set('Last-Modified', null);
        }

        // Strongly prohibit caching for auth-related endpoints
        $response->headers->set('Cache-Control', 'no-store, no-cache, must-revalidate, private');
        $response->headers->set('Pragma', 'no-cache');
        $response->headers->set('Expires', '0');

        return $response;
    }
}